/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.restxq.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.exquery.http.AcceptHeader;
import org.exquery.http.HttpHeader;
import org.exquery.http.HttpMethod;
import org.exquery.http.HttpRequest;
import org.exquery.restxq.RestXqService;
import org.exquery.restxq.RestXqServiceRegistryListener;

public class RestXqServicesMap {
    private final Map<HttpMethod, List<RestXqService>> orderedServices = new EnumMap<HttpMethod, List<RestXqService>>(HttpMethod.class);
    private final Map<HttpMethod, ReentrantReadWriteLock> methodLocks = new EnumMap<HttpMethod, ReentrantReadWriteLock>(HttpMethod.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestXqService put(HttpMethod method, RestXqService service) {
        ReentrantReadWriteLock lock = this.getOrCreateMethodLock(method);
        try {
            lock.writeLock().lock();
            List<RestXqService> list = this.orderedServices.get(method);
            if (list == null) {
                list = new ArrayList<RestXqService>();
            }
            RestXqService oldValue = null;
            int oldIndex = list.indexOf(service);
            if (oldIndex > -1) {
                oldValue = list.remove(oldIndex);
            }
            list.add(service);
            Collections.sort(list);
            this.orderedServices.put(method, list);
            RestXqService restXqService = oldValue;
            return restXqService;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterate(RestXqServiceMapVisitor visitor, boolean eagerLockAll) {
        ReentrantReadWriteLock lock;
        try {
            if (eagerLockAll) {
                for (HttpMethod method : HttpMethod.values()) {
                    lock = this.getOrCreateMethodLock(method);
                    lock.readLock().lock();
                }
                for (HttpMethod method : HttpMethod.values()) {
                    List<RestXqService> services = this.orderedServices.get(method);
                    if (services == null) continue;
                    visitor.visit(method, services);
                }
            } else {
                for (HttpMethod method : HttpMethod.values()) {
                    lock = this.getOrCreateMethodLock(method);
                    lock.readLock().lock();
                    List<RestXqService> services = this.orderedServices.get(method);
                    if (services == null) continue;
                    visitor.visit(method, services);
                }
            }
        }
        finally {
            for (HttpMethod method : HttpMethod.values()) {
                lock = this.getOrCreateMethodLock(method);
                lock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestXqService get(HttpMethod method, HttpRequest request) {
        ReentrantReadWriteLock lock = this.getOrCreateMethodLock(method);
        RestXqService result = null;
        try {
            lock.readLock().lock();
            List<RestXqService> services = this.orderedServices.get(method);
            if (services != null) {
                String acceptHeaderValue = request.getHeader(HttpHeader.ACCEPT.getHeaderName());
                AcceptHeader acceptHeader = acceptHeaderValue != null ? new AcceptHeader(acceptHeaderValue) : null;
                for (RestXqService service : services) {
                    if (!service.canService(request)) continue;
                    if (acceptHeader != null && result != null) {
                        if (!(service.maxProducesQualityFactor(acceptHeader) > result.maxProducesQualityFactor(acceptHeader))) continue;
                        result = service;
                        continue;
                    }
                    result = service;
                }
            }
            RestXqService restXqService = result;
            return restXqService;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(URI xqueryLocation, List<RestXqServiceRegistryListener> listeners) {
        for (HttpMethod key : this.orderedServices.keySet()) {
            ReentrantReadWriteLock lock = this.getOrCreateMethodLock(key);
            try {
                lock.writeLock().lock();
                ArrayList<RestXqService> servicesToRemove = new ArrayList<RestXqService>();
                List<RestXqService> serviceList = this.orderedServices.get(key);
                for (RestXqService service : serviceList) {
                    if (!service.getResourceFunction().getXQueryLocation().equals(xqueryLocation)) continue;
                    servicesToRemove.add(service);
                }
                if (servicesToRemove.isEmpty()) continue;
                for (RestXqService serviceToRemove : servicesToRemove) {
                    serviceList.remove(serviceToRemove);
                }
                this.orderedServices.put(key, serviceList);
                for (RestXqServiceRegistryListener listener : listeners) {
                    for (RestXqService service : servicesToRemove) {
                        listener.deregistered(service);
                    }
                }
            }
            finally {
                lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(RestXqService service, List<RestXqServiceRegistryListener> listeners) {
        for (HttpMethod key : this.orderedServices.keySet()) {
            ReentrantReadWriteLock lock = this.getOrCreateMethodLock(key);
            try {
                lock.writeLock().lock();
                RestXqService serviceToRemove = null;
                List<RestXqService> serviceList = this.orderedServices.get(key);
                for (RestXqService orderedService : serviceList) {
                    if (!orderedService.equals(service)) continue;
                    serviceToRemove = orderedService;
                    break;
                }
                if (serviceToRemove == null) continue;
                serviceList.remove(serviceToRemove);
                this.orderedServices.put(key, serviceList);
                for (RestXqServiceRegistryListener listener : listeners) {
                    listener.deregistered(serviceToRemove);
                }
            }
            finally {
                lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantReadWriteLock getOrCreateMethodLock(HttpMethod method) {
        Map<HttpMethod, ReentrantReadWriteLock> map = this.methodLocks;
        synchronized (map) {
            ReentrantReadWriteLock lock = this.methodLocks.get(method);
            if (lock == null) {
                lock = new ReentrantReadWriteLock();
                this.methodLocks.put(method, lock);
            }
            return lock;
        }
    }

    protected static interface RestXqServiceMapVisitor {
        public void visit(HttpMethod var1, List<RestXqService> var2);
    }
}

