/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.restxq.impl.annotation;

import java.util.regex.Matcher;
import org.exquery.restxq.RestXqErrorCodes;
import org.exquery.restxq.annotation.HttpMethodWithBodyAnnotation;
import org.exquery.restxq.annotation.RestAnnotationException;
import org.exquery.restxq.impl.annotation.AbstractHttpMethodAnnotation;
import org.exquery.xquery.Cardinality;
import org.exquery.xquery.Literal;
import org.exquery.xquery.Type;

public abstract class AbstractHttpMethodWithBodyAnnotation
extends AbstractHttpMethodAnnotation
implements HttpMethodWithBodyAnnotation {
    private String bodyParameterName;

    @Override
    public void initialise() throws RestAnnotationException {
        super.initialise();
        this.bodyParameterName = this.parseAnnotationValue();
    }

    public String getBodyParameterName() {
        return this.bodyParameterName;
    }

    protected String parseAnnotationValue() throws RestAnnotationException {
        Literal[] annotationLiterals = this.getLiterals();
        if (annotationLiterals.length > 1) {
            throw new RestAnnotationException(RestXqErrorCodes.RQST0010);
        }
        if (annotationLiterals.length != 1) {
            return null;
        }
        return this.parseMethodBodyValue(annotationLiterals[0]);
    }

    protected String parseMethodBodyValue(Literal methodValue) throws RestAnnotationException {
        if (methodValue.getType() != Type.STRING) {
            throw new RestAnnotationException(RestXqErrorCodes.RQST0011);
        }
        String methodStr = methodValue.getValue();
        if (methodStr.isEmpty()) {
            throw new RestAnnotationException(RestXqErrorCodes.RQST0012);
        }
        Matcher mtcFunctionArgument = functionArgumentPattern.matcher(methodStr);
        if (!mtcFunctionArgument.matches()) {
            throw new RestAnnotationException(RestXqErrorCodes.RQST0013);
        }
        String bodyContentParamName = mtcFunctionArgument.group(1);
        this.checkFnDeclaresParameter(this.getFunctionSignature(), bodyContentParamName);
        return bodyContentParamName;
    }

    @Override
    protected Cardinality getRequiredFunctionParameterCardinality() {
        return Cardinality.ONE;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidFunctionParameterCardinalityErr() {
        return RestXqErrorCodes.RQST0005;
    }

    @Override
    protected Type getRequiredFunctionParameterType() {
        return Type.ITEM;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidFunctionParameterTypeErr() {
        return RestXqErrorCodes.RQST0033;
    }
}

