/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.restxq.impl.annotation;

import java.util.Collection;
import java.util.regex.Matcher;
import org.exquery.restxq.RestXqErrorCodes;
import org.exquery.restxq.annotation.ParameterAnnotation;
import org.exquery.restxq.annotation.RestAnnotationException;
import org.exquery.restxq.impl.annotation.AbstractRestAnnotation;
import org.exquery.restxq.impl.annotation.ParameterAnnotationMapping;
import org.exquery.xdm.type.SequenceImpl;
import org.exquery.xdm.type.StringTypedValue;
import org.exquery.xquery.Cardinality;
import org.exquery.xquery.Literal;
import org.exquery.xquery.Sequence;
import org.exquery.xquery.Type;
import org.exquery.xquery.TypedValue;

public abstract class AbstractParameterAnnotation
extends AbstractRestAnnotation
implements ParameterAnnotation {
    private ParameterAnnotationMapping parameterAnnotationMapping;

    public void initialise() throws RestAnnotationException {
        super.initialise();
        this.parameterAnnotationMapping = this.parseAnnotationValue();
    }

    protected ParameterAnnotationMapping getParameterAnnotationMapping() {
        return this.parameterAnnotationMapping;
    }

    protected ParameterAnnotationMapping parseAnnotationValue() throws RestAnnotationException {
        Literal[] annotationLiterals = this.getLiterals();
        if (annotationLiterals.length != 2) {
            throw new RestAnnotationException(this.getInvalidAnnotationParamsErr());
        }
        return this.parseAnnotationLiterals(annotationLiterals[0], annotationLiterals[1], Cardinality.ZERO_OR_MORE);
    }

    protected final ParameterAnnotationMapping parseAnnotationLiterals(Literal parameterName, Literal functionArgumentName, Cardinality requiredCardinality) throws RestAnnotationException {
        if (parameterName.getType() != Type.STRING) {
            throw new RestAnnotationException(this.getInvalidParameterNameErr());
        }
        if (functionArgumentName.getType() != Type.STRING) {
            throw new RestAnnotationException(this.getInvalidFunctionArgumentNameErr());
        }
        String keyStr = parameterName.getValue();
        String varStr = functionArgumentName.getValue();
        if (keyStr.isEmpty()) {
            throw new RestAnnotationException(this.getInvalidParameterNameErr());
        }
        if (varStr.isEmpty()) {
            throw new RestAnnotationException(this.getInvalidFunctionArgumentNameErr());
        }
        Matcher mtcFnParameter = functionArgumentPattern.matcher(varStr);
        if (!mtcFnParameter.matches()) {
            throw new RestAnnotationException(this.getInvalidAnnotationParametersSyntaxErr());
        }
        String varName = mtcFnParameter.group(1);
        this.checkFnDeclaresParameter(this.getFunctionSignature(), varName, requiredCardinality);
        return new ParameterAnnotationMapping(keyStr, varName);
    }

    protected Sequence<String> collectionToSequence(Collection<String> collection) {
        SequenceImpl sequence = new SequenceImpl();
        for (String value : collection) {
            sequence.add((TypedValue)new StringTypedValue(value));
        }
        return sequence;
    }

    @Override
    protected Cardinality getRequiredFunctionParameterCardinality() {
        return Cardinality.ZERO_OR_MORE;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidFunctionParameterCardinalityErr() {
        return RestXqErrorCodes.RQST0034;
    }

    @Override
    protected Type getRequiredFunctionParameterType() {
        return Type.ANY_ATOMIC_TYPE;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidFunctionParameterTypeErr() {
        return RestXqErrorCodes.RQST0006;
    }

    protected abstract RestXqErrorCodes.RestXqErrorCode getInvalidAnnotationParamsErr();

    protected abstract RestXqErrorCodes.RestXqErrorCode getInvalidParameterNameErr();

    protected abstract RestXqErrorCodes.RestXqErrorCode getInvalidFunctionArgumentNameErr();

    protected abstract RestXqErrorCodes.RestXqErrorCode getInvalidDefaultValueErr();

    protected abstract RestXqErrorCodes.RestXqErrorCode getInvalidDefaultValueTypeErr();

    protected abstract RestXqErrorCodes.RestXqErrorCode getInvalidAnnotationParametersSyntaxErr();
}

