/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.restxq.impl.annotation;

import java.util.Arrays;
import org.exquery.restxq.annotation.RestAnnotationException;
import org.exquery.restxq.impl.annotation.AbstractParameterAnnotation;
import org.exquery.restxq.impl.annotation.ParameterAnnotationMapping;
import org.exquery.xdm.type.SequenceImpl;
import org.exquery.xdm.type.StringTypedValue;
import org.exquery.xquery.Cardinality;
import org.exquery.xquery.Literal;
import org.exquery.xquery.Sequence;
import org.exquery.xquery.Type;
import org.exquery.xquery.TypedValue;

public abstract class AbstractParameterWithDefaultAnnotation
extends AbstractParameterAnnotation {
    @Override
    protected ParameterAnnotationMapping parseAnnotationValue() throws RestAnnotationException {
        Literal[] defaultValueLiterals;
        Literal[] annotationLiterals = this.getLiterals();
        if (annotationLiterals.length < 2) {
            throw new RestAnnotationException(this.getInvalidAnnotationParamsErr());
        }
        for (Literal defaultValueLiteral : defaultValueLiterals = Arrays.copyOfRange(annotationLiterals, 2, annotationLiterals.length)) {
            if (defaultValueLiteral.getType().isSubTypeOf(Type.ANY_SIMPLE_TYPE)) continue;
            throw new RestAnnotationException(this.getInvalidDefaultValueErr());
        }
        return this.parseAnnotationLiterals(annotationLiterals[0], annotationLiterals[1], defaultValueLiterals);
    }

    private ParameterAnnotationMapping parseAnnotationLiterals(Literal parameterName, Literal functionArgumentName, Literal[] defaultValueLiterals) throws RestAnnotationException {
        Cardinality requiredCardinality = defaultValueLiterals.length == 0 ? Cardinality.ZERO_OR_MORE : Cardinality.ONE_OR_MORE;
        ParameterAnnotationMapping mapping = super.parseAnnotationLiterals(parameterName, functionArgumentName, requiredCardinality);
        if (defaultValueLiterals.length > 0) {
            Type requiredType = this.haveConsistentType(defaultValueLiterals) ? defaultValueLiterals[0].getType() : Type.ANY_SIMPLE_TYPE;
            this.checkFnDeclaresParameterWithType(this.getFunctionSignature(), mapping.getFunctionArgumentName(), requiredType, this.getInvalidDefaultValueTypeErr());
        }
        return new ParameterAnnotationMapping(mapping.getParameterName(), mapping.getFunctionArgumentName(), defaultValueLiterals);
    }

    private boolean haveConsistentType(Literal[] literals) {
        if (literals == null || literals.length == 0) {
            return true;
        }
        Type type = literals[0].getType();
        for (Literal literal : literals) {
            if (literal.getType().equals((Object)type)) continue;
            return false;
        }
        return true;
    }

    protected Sequence literalsToSequence(Literal[] literals) {
        SequenceImpl sequence = new SequenceImpl();
        for (Literal literal : literals) {
            sequence.add((TypedValue)new StringTypedValue(literal.getValue()));
        }
        return sequence;
    }
}

