/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.restxq.impl.annotation;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.exquery.annotation.AbstractAnnotation;
import org.exquery.restxq.RestXqErrorCodes;
import org.exquery.restxq.annotation.RestAnnotation;
import org.exquery.restxq.annotation.RestAnnotationException;
import org.exquery.xquery.Cardinality;
import org.exquery.xquery.FunctionArgument;
import org.exquery.xquery.Type;
import org.exquery.xquery3.FunctionSignature;

public abstract class AbstractRestAnnotation
extends AbstractAnnotation<RestAnnotationException>
implements RestAnnotation {
    protected static final String functionArgumentRegExp = "\\{\\$((?:[A-Za-z0-9_\\-]+:)?[A-Za-z0-9_\\-]+)\\}";
    protected static final Pattern functionArgumentPattern = Pattern.compile("\\{\\$((?:[A-Za-z0-9_\\-]+:)?[A-Za-z0-9_\\-]+)\\}");

    protected void checkFnDeclaresParameterWithType(FunctionSignature functionSignature, String fnArgumentName, Type requiredArgumentType, RestXqErrorCodes.RestXqErrorCode errorCode) throws RestAnnotationException {
        FunctionArgument[] fnArguments = functionSignature.getArguments();
        boolean found = false;
        for (FunctionArgument fnArgument : fnArguments) {
            if (!fnArgument.getName().equals(fnArgumentName)) continue;
            if (!this.hasCompatibleType(fnArgument.getType(), requiredArgumentType)) {
                throw new RestAnnotationException(errorCode);
            }
            found = true;
            break;
        }
        if (!found) {
            throw new RestAnnotationException(RestXqErrorCodes.RQST0007);
        }
    }

    protected void checkFnDeclaresParameter(FunctionSignature functionSignature, String fnArgumentName) throws RestAnnotationException {
        this.checkFnDeclaresParameter(functionSignature, fnArgumentName, this.getRequiredFunctionParameterCardinality());
    }

    protected void checkFnDeclaresParameter(FunctionSignature functionSignature, String fnArgumentName, Cardinality requiredCardinality) throws RestAnnotationException {
        ArrayList<String> fnParamNames = new ArrayList<String>(1);
        fnParamNames.add(fnArgumentName);
        this.checkFnDeclaresParameters(functionSignature, fnParamNames, requiredCardinality);
    }

    protected void checkFnDeclaresParameters(FunctionSignature functionSignature, List<String> fnArgumentNames) throws RestAnnotationException {
        this.checkFnDeclaresParameters(functionSignature, fnArgumentNames, this.getRequiredFunctionParameterCardinality());
    }

    protected void checkFnDeclaresParameters(FunctionSignature functionSignature, List<String> fnArgumentNames, Cardinality requiredCardinality) throws RestAnnotationException {
        FunctionArgument[] fnArguments = functionSignature.getArguments();
        for (String fnArgumentName : fnArgumentNames) {
            boolean found = false;
            for (FunctionArgument fnArgument : fnArguments) {
                if (!fnArgument.getName().equals(fnArgumentName)) continue;
                if (!fnArgument.getCardinality().hasRequiredCardinality(requiredCardinality)) {
                    throw new RestAnnotationException(this.getInvalidFunctionParameterCardinalityErr());
                }
                if (!this.hasCompatibleType(fnArgument.getType(), this.getRequiredFunctionParameterType())) {
                    throw new RestAnnotationException(this.getInvalidFunctionParameterTypeErr());
                }
                found = true;
                break;
            }
            if (found) continue;
            throw new RestAnnotationException(RestXqErrorCodes.RQST0007);
        }
    }

    private boolean hasCompatibleType(Type actualType, Type requiredType) {
        return actualType.hasSubType(requiredType) | requiredType.hasSubType(actualType);
    }

    protected abstract Cardinality getRequiredFunctionParameterCardinality();

    protected abstract RestXqErrorCodes.RestXqErrorCode getInvalidFunctionParameterCardinalityErr();

    protected abstract Type getRequiredFunctionParameterType();

    protected abstract RestXqErrorCodes.RestXqErrorCode getInvalidFunctionParameterTypeErr();
}

