/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.restxq.impl.annotation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exquery.http.ContentTypeHeader;
import org.exquery.http.HttpRequest;
import org.exquery.restxq.RestXqErrorCodes;
import org.exquery.restxq.annotation.ConsumesAnnotation;
import org.exquery.restxq.annotation.RestAnnotationException;
import org.exquery.restxq.impl.annotation.AbstractMediaTypeAnnotation;
import org.exquery.xquery.Literal;
import org.exquery.xquery.Type;

public class ConsumesAnnotationImpl
extends AbstractMediaTypeAnnotation
implements ConsumesAnnotation {
    private static final Pattern ptnMediaType = Pattern.compile("(?:[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}\\/[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127})|(?:[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}\\/\\*)");
    private Pattern ptnMatchMediaTypes;

    public void initialise() throws RestAnnotationException {
        super.initialise();
        this.ptnMatchMediaTypes = this.parseAnnotationValue();
    }

    protected Pattern getMediaTypesPatternMatcher() {
        return this.ptnMatchMediaTypes;
    }

    protected Pattern parseAnnotationValue() throws RestAnnotationException {
        Literal[] annotationLiterals = this.getLiterals();
        if (annotationLiterals.length == 0) {
            throw new RestAnnotationException(this.getEmptyAnnotationParamsErr());
        }
        return this.parseAnnotationLiterals(annotationLiterals);
    }

    protected Pattern parseAnnotationLiterals(Literal[] mediaTypesLiterals) throws RestAnnotationException {
        Matcher mtcMediaType = null;
        StringBuilder builder = new StringBuilder();
        for (Literal mediaTypeLiteral : mediaTypesLiterals) {
            if (mediaTypeLiteral.getType() != Type.STRING) {
                throw new RestAnnotationException(this.getInvalidMediaTypeLiteralErr());
            }
            String mediaType = mediaTypeLiteral.getValue();
            if (mediaType.isEmpty()) {
                throw new RestAnnotationException(this.getInvalidMediaTypeErr());
            }
            if (!(mtcMediaType = mtcMediaType == null ? ptnMediaType.matcher(mediaType) : mtcMediaType.reset(mediaType)).matches()) {
                throw new RestAnnotationException(this.getInvalidMediaTypeErr());
            }
            if (builder.length() != 0) {
                builder.append("|");
            }
            builder.append("(?:");
            builder.append(this.encodeAsRegExp(mediaType));
            builder.append(")");
        }
        return Pattern.compile(builder.toString());
    }

    public boolean matchesMediaType(HttpRequest request) {
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return this.matchesMediaType(contentType);
    }

    public boolean matchesMediaType(String mediaType) {
        ContentTypeHeader contentTypeHeader = new ContentTypeHeader(mediaType);
        return this.getMediaTypesPatternMatcher().matcher(contentTypeHeader.getInternetMediaType()).matches();
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getEmptyAnnotationParamsErr() {
        return RestXqErrorCodes.RQST0027;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidMediaTypeLiteralErr() {
        return RestXqErrorCodes.RQST0028;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidMediaTypeErr() {
        return RestXqErrorCodes.RQST0029;
    }
}

