/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.restxq.impl.annotation;

import org.exquery.http.HttpRequest;
import org.exquery.restxq.RestXqErrorCodes;
import org.exquery.restxq.impl.annotation.AbstractParameterWithDefaultAnnotation;
import org.exquery.xdm.type.SequenceImpl;
import org.exquery.xdm.type.StringTypedValue;
import org.exquery.xquery.Cardinality;
import org.exquery.xquery.Literal;
import org.exquery.xquery.Sequence;
import org.exquery.xquery.TypedArgumentValue;
import org.exquery.xquery.TypedValue;

public class CookieParameterAnnotation
extends AbstractParameterWithDefaultAnnotation {
    public TypedArgumentValue<String> extractParameter(final HttpRequest request) {
        return new TypedArgumentValue<String>(){

            public String getArgumentName() {
                return CookieParameterAnnotation.this.getParameterAnnotationMapping().getFunctionArgumentName();
            }

            public Sequence<String> getTypedValue() {
                String queryParam = request.getCookieValue(CookieParameterAnnotation.this.getParameterAnnotationMapping().getParameterName());
                if (queryParam == null) {
                    Literal[] defaultLiterals = CookieParameterAnnotation.this.getParameterAnnotationMapping().getDefaultValues();
                    if (defaultLiterals.length > 0) {
                        return CookieParameterAnnotation.this.literalsToSequence(defaultLiterals);
                    }
                    return Sequence.EMPTY_SEQUENCE;
                }
                if (queryParam instanceof String) {
                    return new SequenceImpl((TypedValue)new StringTypedValue(queryParam));
                }
                return null;
            }
        };
    }

    @Override
    protected Cardinality getRequiredFunctionParameterCardinality() {
        return Cardinality.ZERO_OR_ONE;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidAnnotationParamsErr() {
        return RestXqErrorCodes.RQST0041;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidParameterNameErr() {
        return RestXqErrorCodes.RQST0042;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidFunctionArgumentNameErr() {
        return RestXqErrorCodes.RQST0043;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidDefaultValueErr() {
        return RestXqErrorCodes.RQST0044;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidDefaultValueTypeErr() {
        return RestXqErrorCodes.RQST0045;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidAnnotationParametersSyntaxErr() {
        return RestXqErrorCodes.RQST0046;
    }
}

