/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.restxq.impl.annotation;

import java.io.InputStream;
import java.util.List;
import org.exquery.http.HttpRequest;
import org.exquery.restxq.RestXqErrorCodes;
import org.exquery.restxq.impl.annotation.AbstractParameterWithDefaultAnnotation;
import org.exquery.xdm.type.Base64BinaryTypedValue;
import org.exquery.xdm.type.SequenceImpl;
import org.exquery.xdm.type.StringTypedValue;
import org.exquery.xquery.Literal;
import org.exquery.xquery.Sequence;
import org.exquery.xquery.TypedArgumentValue;
import org.exquery.xquery.TypedValue;

public class FormParameterAnnotation
extends AbstractParameterWithDefaultAnnotation {
    public TypedArgumentValue extractParameter(final HttpRequest request) {
        return new TypedArgumentValue(){

            public String getArgumentName() {
                return FormParameterAnnotation.this.getParameterAnnotationMapping().getFunctionArgumentName();
            }

            public Sequence getTypedValue() {
                Object formParam = request.getFormParam(FormParameterAnnotation.this.getParameterAnnotationMapping().getParameterName());
                if (formParam == null) {
                    Literal[] defaultLiterals = FormParameterAnnotation.this.getParameterAnnotationMapping().getDefaultValues();
                    return FormParameterAnnotation.this.literalsToSequence(defaultLiterals);
                }
                if (formParam instanceof String) {
                    return new SequenceImpl((TypedValue)new StringTypedValue((String)formParam));
                }
                if (formParam instanceof List) {
                    List formFieldValues = (List)formParam;
                    return FormParameterAnnotation.this.collectionToSequence(formFieldValues);
                }
                if (formParam instanceof InputStream) {
                    return new SequenceImpl((TypedValue)new Base64BinaryTypedValue((InputStream)formParam));
                }
                return null;
            }
        };
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidAnnotationParamsErr() {
        return RestXqErrorCodes.RQST0015;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidParameterNameErr() {
        return RestXqErrorCodes.RQST0016;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidFunctionArgumentNameErr() {
        return RestXqErrorCodes.RQST0017;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidDefaultValueErr() {
        return RestXqErrorCodes.RQST0018;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidDefaultValueTypeErr() {
        return RestXqErrorCodes.RQST0019;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidAnnotationParametersSyntaxErr() {
        return RestXqErrorCodes.RQST0020;
    }
}

