/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.restxq.impl.annotation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exquery.restxq.RestXqErrorCodes;
import org.exquery.restxq.annotation.PathAnnotation;
import org.exquery.restxq.annotation.RestAnnotationException;
import org.exquery.restxq.impl.annotation.AbstractRestAnnotation;
import org.exquery.xquery.Cardinality;
import org.exquery.xquery.Literal;
import org.exquery.xquery.Type;

public class PathAnnotationImpl
extends AbstractRestAnnotation
implements PathAnnotation {
    protected static final int PATH_SEGMENT_PARAM_SPECIFICITY = 0;
    protected static final int PATH_SEGMENT_SOLID_SPECIFICITY = 1;
    public static final String pathSegmentRegExp = "(?:(?:[A-Za-z0-9\\-\\._~]|%[A-F0-9]{2}|[!\\$&'\\(\\)\\*\\+,;=]|[\\:@])+|\\{\\$((?:[A-Za-z0-9_\\-]+:)?[A-Za-z0-9_\\-]+)\\})";
    public static final Pattern ptnPathSegment = Pattern.compile("(?:(?:[A-Za-z0-9\\-\\._~]|%[A-F0-9]{2}|[!\\$&'\\(\\)\\*\\+,;=]|[\\:@])+|\\{\\$((?:[A-Za-z0-9_\\-]+:)?[A-Za-z0-9_\\-]+)\\})");
    public static final String pathRegExp = "^(?:/?(?:(?:[A-Za-z0-9\\-\\._~]|%[A-F0-9]{2}|[!\\$&'\\(\\)\\*\\+,;=]|[\\:@])+|\\{\\$((?:[A-Za-z0-9_\\-]+:)?[A-Za-z0-9_\\-]+)\\}))+$";
    public static final Pattern ptnPath = Pattern.compile("^(?:/?(?:(?:[A-Za-z0-9\\-\\._~]|%[A-F0-9]{2}|[!\\$&'\\(\\)\\*\\+,;=]|[\\:@])+|\\{\\$((?:[A-Za-z0-9_\\-]+:)?[A-Za-z0-9_\\-]+)\\}))+$");
    private PathInformation pathRegularExpression;

    public void initialise() throws RestAnnotationException {
        super.initialise();
        this.pathRegularExpression = this.parsePath();
    }

    public boolean matchesPath(String path) {
        Matcher m = this.getPathInformation().getPathMatcher(path);
        return m.matches();
    }

    public Map<String, String> extractPathParameters(String uriPath) {
        HashMap<String, String> pathParamNameAndValues = new HashMap<String, String>();
        Matcher m = this.getPathInformation().getPathMatcher(uriPath);
        if (m.matches()) {
            for (int i = 1; i <= m.groupCount(); ++i) {
                String paramName = this.getPathInformation().getFnParamNameForGroup(i);
                String paramValue = m.group(i);
                pathParamNameAndValues.put(paramName, paramValue);
            }
        }
        return pathParamNameAndValues;
    }

    public long getPathSpecificityMetric() {
        return this.getPathInformation().getPathSpecificityMetric();
    }

    protected PathInformation getPathInformation() {
        return this.pathRegularExpression;
    }

    protected PathInformation parsePath() throws RestAnnotationException {
        Literal[] annotationValue = this.getLiterals();
        if (annotationValue.length != 1) {
            throw new RestAnnotationException(RestXqErrorCodes.RQST0001);
        }
        Literal pathValue = annotationValue[0];
        if (pathValue.getType() != Type.STRING) {
            throw new RestAnnotationException(RestXqErrorCodes.RQST0002);
        }
        String pathStr = pathValue.getValue();
        if (pathStr.isEmpty()) {
            throw new RestAnnotationException(RestXqErrorCodes.RQST0003);
        }
        Matcher mchPath = ptnPath.matcher(pathStr);
        if (!mchPath.matches()) {
            throw new RestAnnotationException(RestXqErrorCodes.RQST0004);
        }
        StringBuilder thisPathExprRegExp = new StringBuilder();
        ArrayList<String> pathFnParams = new ArrayList<String>();
        Matcher mchPathSegment = ptnPathSegment.matcher(pathStr);
        HashMap<Integer, String> groupParamNames = new HashMap<Integer, String>();
        int groupCount = 0;
        long pathSpecificityMetric = 0L;
        while (mchPathSegment.find()) {
            String pathSegmentOrPart = pathStr.substring(mchPathSegment.start(), mchPathSegment.end());
            Matcher mtcFnParameter = functionArgumentPattern.matcher(pathSegmentOrPart);
            int idxPrePathSegment = mchPathSegment.start() - 1;
            if (idxPrePathSegment > -1) {
                if (pathStr.charAt(idxPrePathSegment) == '/') {
                    thisPathExprRegExp.append('/');
                }
            } else {
                thisPathExprRegExp.append('/');
            }
            if (pathSpecificityMetric == 0L) {
                pathSpecificityMetric = 1L;
            }
            pathSpecificityMetric <<= 1;
            if (mtcFnParameter.matches()) {
                String fnParamName = mtcFnParameter.replaceFirst("$1");
                pathFnParams.add(fnParamName);
                thisPathExprRegExp.append("(");
                thisPathExprRegExp.append("(?:[A-Za-z0-9\\-\\._~]|%[A-F0-9]{2}|[!\\$&'\\(\\)\\*\\+,;=]|[\\:@])+");
                thisPathExprRegExp.append(")");
                groupParamNames.put(++groupCount, fnParamName);
                pathSpecificityMetric ^= 0L;
                continue;
            }
            thisPathExprRegExp.append("(?:");
            thisPathExprRegExp.append(Pattern.quote(pathSegmentOrPart));
            thisPathExprRegExp.append(")");
            pathSpecificityMetric ^= 1L;
        }
        this.checkFnDeclaresParameters(this.getFunctionSignature(), pathFnParams);
        Pattern ptnThisPath = Pattern.compile(thisPathExprRegExp.toString());
        return new PathInformation(pathStr, ptnThisPath, groupParamNames, pathSpecificityMetric);
    }

    @Override
    protected Cardinality getRequiredFunctionParameterCardinality() {
        return Cardinality.ONE;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidFunctionParameterCardinalityErr() {
        return RestXqErrorCodes.RQST0005;
    }

    @Override
    protected Type getRequiredFunctionParameterType() {
        return Type.ANY_ATOMIC_TYPE;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidFunctionParameterTypeErr() {
        return RestXqErrorCodes.RQST0006;
    }

    protected class PathInformation {
        private final String pathLiteral;
        private final Pattern ptnPath;
        private final Map<Integer, String> groupParamNames;
        private final long pathSpecificityMetric;

        public PathInformation(String pathLiteral, Pattern ptnPath, Map<Integer, String> groupParamNames, long pathSpecificityMetric) {
            this.pathLiteral = pathLiteral;
            this.ptnPath = ptnPath;
            this.groupParamNames = groupParamNames;
            this.pathSpecificityMetric = pathSpecificityMetric;
        }

        public String getPathLiteral() {
            return this.pathLiteral;
        }

        public Matcher getPathMatcher(String path) {
            return this.ptnPath.matcher(path);
        }

        public String getFnParamNameForGroup(int groupIndex) {
            return this.groupParamNames.get(groupIndex);
        }

        public long getPathSpecificityMetric() {
            return this.pathSpecificityMetric;
        }
    }
}

