/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.restxq.impl.annotation;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exquery.http.AcceptHeader;
import org.exquery.http.HttpHeaderName;
import org.exquery.http.HttpRequest;
import org.exquery.restxq.RestXqErrorCodes;
import org.exquery.restxq.annotation.ProducesAnnotation;
import org.exquery.restxq.annotation.RestAnnotationException;
import org.exquery.restxq.impl.annotation.AbstractMediaTypeAnnotation;
import org.exquery.xquery.Literal;
import org.exquery.xquery.Type;

public class ProducesAnnotationImpl
extends AbstractMediaTypeAnnotation
implements ProducesAnnotation {
    private static final Pattern ptnMediaType = Pattern.compile("[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}\\/[a-z0-9!#\\$&\\.\\+\\-\\^_]{1,127}");
    private Set<String> internetMediaTypes;

    public void initialise() throws RestAnnotationException {
        super.initialise();
        this.internetMediaTypes = this.parseAnnotationValue();
    }

    protected Set<String> parseAnnotationValue() throws RestAnnotationException {
        Literal[] annotationLiterals = this.getLiterals();
        if (annotationLiterals.length == 0) {
            throw new RestAnnotationException(this.getEmptyAnnotationParamsErr());
        }
        return this.parseAnnotationLiterals(annotationLiterals);
    }

    protected Set<String> parseAnnotationLiterals(Literal[] mediaTypesLiterals) throws RestAnnotationException {
        Matcher mtcMediaType = null;
        HashSet<String> mediaTypes = new HashSet<String>();
        for (Literal mediaTypeLiteral : mediaTypesLiterals) {
            if (mediaTypeLiteral.getType() != Type.STRING) {
                throw new RestAnnotationException(this.getInvalidMediaTypeLiteralErr());
            }
            String mediaType = mediaTypeLiteral.getValue();
            if (mediaType.isEmpty()) {
                throw new RestAnnotationException(this.getInvalidMediaTypeErr());
            }
            if (!(mtcMediaType = mtcMediaType == null ? ptnMediaType.matcher(mediaType) : mtcMediaType.reset(mediaType)).matches()) {
                throw new RestAnnotationException(this.getInvalidMediaTypeErr());
            }
            mediaTypes.add(mediaType);
        }
        return mediaTypes;
    }

    public boolean matchesMediaType(HttpRequest request) {
        String acceptHeaderValue = request.getHeader(HttpHeaderName.Accept.toString());
        if (acceptHeaderValue == null) {
            acceptHeaderValue = "*/*";
        }
        return this.matchesMediaType(acceptHeaderValue);
    }

    public boolean matchesMediaType(String mediaType) {
        AcceptHeader acceptHeader = new AcceptHeader(mediaType);
        for (AcceptHeader.Accept accept : acceptHeader.getAccepts()) {
            Pattern pEncodedMediaType = Pattern.compile(this.encodeAsRegExp(accept.getMediaRange()));
            Matcher mtcMediaType = null;
            for (String internetMediaType : this.internetMediaTypes) {
                if (!(mtcMediaType = mtcMediaType == null ? pEncodedMediaType.matcher(internetMediaType) : mtcMediaType.reset(internetMediaType)).matches()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getEmptyAnnotationParamsErr() {
        return RestXqErrorCodes.RQST0030;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidMediaTypeLiteralErr() {
        return RestXqErrorCodes.RQST0031;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidMediaTypeErr() {
        return RestXqErrorCodes.RQST0032;
    }
}

