/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.restxq.impl.annotation;

import javax.xml.namespace.QName;
import org.exquery.annotation.AnnotationException;
import org.exquery.restxq.annotation.RestAnnotation;
import org.exquery.restxq.annotation.RestAnnotationException;
import org.exquery.restxq.annotation.RestAnnotationName;
import org.exquery.restxq.impl.annotation.AbstractRestAnnotation;
import org.exquery.restxq.impl.annotation.ConsumesAnnotationImpl;
import org.exquery.restxq.impl.annotation.CookieParameterAnnotation;
import org.exquery.restxq.impl.annotation.DeleteMethodAnnotation;
import org.exquery.restxq.impl.annotation.FormParameterAnnotation;
import org.exquery.restxq.impl.annotation.GetMethodAnnotation;
import org.exquery.restxq.impl.annotation.HeadMethodAnnotation;
import org.exquery.restxq.impl.annotation.HeaderParameterAnnotation;
import org.exquery.restxq.impl.annotation.OptionsMethodAnnotation;
import org.exquery.restxq.impl.annotation.PathAnnotationImpl;
import org.exquery.restxq.impl.annotation.PostMethodAnnotation;
import org.exquery.restxq.impl.annotation.ProducesAnnotationImpl;
import org.exquery.restxq.impl.annotation.PutMethodAnnotation;
import org.exquery.restxq.impl.annotation.QueryParameterAnnotation;
import org.exquery.serialization.annotation.SerializationAnnotationFactory;
import org.exquery.xquery3.Annotation;

public class RestAnnotationFactory {
    public static boolean isRestXqAnnotation(QName annotationName) {
        return RestAnnotationFactory.isRestAnnotation(annotationName) || SerializationAnnotationFactory.isSerializationAnnotation((QName)annotationName);
    }

    public static boolean isRestAnnotation(QName annotationName) {
        return annotationName.getNamespaceURI().equals("http://exquery.org/ns/restxq");
    }

    public static Annotation getAnnotation(Annotation annotation) throws AnnotationException {
        if (annotation.getName().getNamespaceURI().equals("http://www.w3.org/2010/xslt-xquery-serialization")) {
            return SerializationAnnotationFactory.getAnnotation((Annotation)annotation);
        }
        if (annotation.getName().getNamespaceURI().equals("http://exquery.org/ns/restxq")) {
            return RestAnnotationFactory.getRESTAnnotation(annotation);
        }
        throw new IllegalArgumentException("Unknown annotation: " + annotation.getName().toString());
    }

    protected static RestAnnotation getRESTAnnotation(Annotation annotation) throws RestAnnotationException {
        AbstractRestAnnotation restAnnotation;
        RestAnnotationName an = RestAnnotationName.valueOf((QName)annotation.getName());
        switch (an) {
            case GET: {
                restAnnotation = new GetMethodAnnotation();
                break;
            }
            case HEAD: {
                restAnnotation = new HeadMethodAnnotation();
                break;
            }
            case DELETE: {
                restAnnotation = new DeleteMethodAnnotation();
                break;
            }
            case POST: {
                restAnnotation = new PostMethodAnnotation();
                break;
            }
            case PUT: {
                restAnnotation = new PutMethodAnnotation();
                break;
            }
            case OPTIONS: {
                restAnnotation = new OptionsMethodAnnotation();
                break;
            }
            case path: {
                restAnnotation = new PathAnnotationImpl();
                break;
            }
            case consumes: {
                restAnnotation = new ConsumesAnnotationImpl();
                break;
            }
            case produces: {
                restAnnotation = new ProducesAnnotationImpl();
                break;
            }
            case formparam: {
                restAnnotation = new FormParameterAnnotation();
                break;
            }
            case queryparam: {
                restAnnotation = new QueryParameterAnnotation();
                break;
            }
            case headerparam: {
                restAnnotation = new HeaderParameterAnnotation();
                break;
            }
            case cookieparam: {
                restAnnotation = new CookieParameterAnnotation();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown annotation: " + annotation.getName().toString());
            }
        }
        restAnnotation.setName(annotation.getName());
        restAnnotation.setFunctionSignature(annotation.getFunctionSignature());
        restAnnotation.setLiterals(annotation.getLiterals());
        restAnnotation.initialise();
        return restAnnotation;
    }
}

