/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web;

import de.betterform.agent.web.cache.XFSessionCache;
import de.betterform.generator.XSLTGenerator;
import de.betterform.xml.config.Config;
import de.betterform.xml.config.XFormsConfigException;
import de.betterform.xml.xslt.TransformerService;
import de.betterform.xml.xslt.impl.CachingTransformerService;
import de.betterform.xml.xslt.impl.ClasspathResourceResolver;
import de.betterform.xml.xslt.impl.FileResourceResolver;
import de.betterform.xml.xslt.impl.HttpResourceResolver;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.xml.DOMConfigurator;

public class WebFactory {
    private static final Log LOGGER = LogFactory.getLog(WebFactory.class);
    public static final String BETTERFORM_CONFIG_PATH = "betterform.configfile";
    public static final String LOG_CONFIG = "log4j.file";
    public static final String BETTERFORM_SUBMISSION_RESPONSE = "betterform.submission.response";
    public static final String XSLT_CACHE_PROPERTY = "xslt.cache.enabled";
    public static final String UPLOADDIR_PROPERTY = "uploadDir";
    public static final String RELATIVE_URI_PROPERTY = "forms.uri.relative";
    public static final String ERROPAGE_PROPERTY = "error.page";
    public static final String XFORMS_NODE = "XFormsInputNode";
    public static final String XFORMS_INPUTSTREAM = "XFormsInputStream";
    public static final String XFORMS_INPUTSOURCE = "XFormsInputSource";
    public static final String XFORMS_URI = "XFormsInputURI";
    public static final String FORM_PARAM_NAME = "form";
    public static final String IGNORE_RESPONSEBODY = "filter.ignoreResponseBody";
    private ServletContext servletContext;
    private Config config;
    public static final String USER_AGENT = "useragent";
    public static final String PARSE_RESPONSE_BODY = "betterform.filter.parseResponseBody";
    public static final String IGNORE_RESPONSE_BODY = "betterform.filter.ignoreResponseBody";
    public static final String ACCEPT_CONTENTTYPE = "acceptContentTypePattern";
    public static final String ALL_XML_TYPES = "all_xml";
    private String userAgentId;
    private static final String DO_INIT_LOGGING = "initLogging";

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public Config getConfig() {
        return this.config;
    }

    public void initConfiguration(String userAgentIdent) throws XFormsConfigException {
        LOGGER.info((Object)"--------------- initing betterForm... ---------------");
        this.userAgentId = userAgentIdent;
        String configPath = this.servletContext.getInitParameter(BETTERFORM_CONFIG_PATH);
        if (configPath == null) {
            throw new XFormsConfigException("Parameter 'betterform.configfile' not specified in web.xml");
        }
        String realPath = WebFactory.getRealPath(configPath, this.servletContext);
        this.config = Config.getInstance(realPath);
    }

    public void initTransformerService(String realPath) throws XFormsConfigException {
        CachingTransformerService transformerService = new CachingTransformerService();
        transformerService.addResourceResolver(new FileResourceResolver());
        transformerService.addResourceResolver(new ClasspathResourceResolver(realPath));
        transformerService.addResourceResolver(new HttpResourceResolver());
        boolean xsltCacheEnabled = Config.getInstance().getProperty(XSLT_CACHE_PROPERTY).equalsIgnoreCase("true");
        String xsltPath = "WEB-INF/classes/META-INF/resources/xslt/";
        String xsltDefault = Config.getInstance().getProperty("ui-transform");
        if (xsltCacheEnabled) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"initializing xslt cache");
            }
            try {
                URI defaultTransformUri = this.getXsltURI(xsltPath, xsltDefault);
                transformerService.getTransformer(defaultTransformUri);
                URI errorTransformer = this.getXsltURI(xsltPath, "error.xsl");
                transformerService.getTransformer(errorTransformer);
                URI highlightingErrorTransformer = this.getXsltURI(xsltPath, "highlightError.xsl");
                transformerService.getTransformer(highlightingErrorTransformer);
                if (Config.getInstance().getProperty("betterform.debug-allowed").equals("true")) {
                    URI highlightingDocument = this.getXsltURI(xsltPath, "highlightDocument.xsl");
                    transformerService.getTransformer(highlightingDocument);
                }
                if (Config.getInstance().getProperty("webprocessor.doIncludes", "false").equals("true")) {
                    URI IncludeDocument = this.getXsltURI(xsltPath, "include.xsl");
                    transformerService.getTransformer(IncludeDocument);
                }
            }
            catch (Exception e) {
                throw new XFormsConfigException(e);
            }
        }
        this.servletContext.setAttribute(TransformerService.TRANSFORMER_SERVICE, (Object)transformerService);
    }

    public static XSLTGenerator setupTransformer(URI uri, ServletContext context) throws URISyntaxException {
        TransformerService transformerService = (TransformerService)context.getAttribute(TransformerService.TRANSFORMER_SERVICE);
        XSLTGenerator generator = new XSLTGenerator();
        generator.setTransformerService(transformerService);
        generator.setStylesheetURI(uri);
        return generator;
    }

    public URI getXsltURI(String xsltPath, String xsltDefault) throws URISyntaxException, XFormsConfigException {
        String resolvePath = WebFactory.getRealPath(xsltPath + xsltDefault, this.servletContext);
        String pathToXSLDirectory = resolvePath.substring(0, resolvePath.lastIndexOf(File.separator));
        return new File(pathToXSLDirectory).toURI().resolve(new URI(xsltDefault));
    }

    public void initLogging(Class theClass) throws XFormsConfigException {
        String initLogging = this.config.getProperty(DO_INIT_LOGGING);
        if (initLogging.equals("true")) {
            String pathToLog4jConfig = WebFactory.getRealPath(this.config.getProperty(LOG_CONFIG), this.servletContext);
            File log4jFile = new File(pathToLog4jConfig);
            if (log4jFile.exists()) {
                DOMConfigurator.configure((String)pathToLog4jConfig);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Logger initialized");
                }
            } else if (LOGGER.isWarnEnabled()) {
                LOGGER.warn((Object)("Could not find " + pathToLog4jConfig));
            }
        }
    }

    public static final String resolvePath(String resolvePath, ServletContext servletContext) {
        String path = resolvePath;
        try {
            URL pathURL;
            if (path != null && !path.startsWith("/")) {
                path = "/" + path;
            }
            if ((pathURL = servletContext.getResource(path)) != null) {
                path = URLDecoder.decode(pathURL.getPath(), StandardCharsets.UTF_8.name());
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        return path;
    }

    public void initXFormsSessionCache() throws XFormsConfigException {
        XFSessionCache.getCache();
    }

    public static String getRealPath(String path, ServletContext context) throws XFormsConfigException {
        if (path == null) {
            path = "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        try {
            URI resourceURI = null;
            String computedRealPath = null;
            URL rootURL = Thread.currentThread().getContextClassLoader().getResource("/");
            URL resourceURL = context.getResource(path);
            if (rootURL != null) {
                resourceURI = rootURL.toURI();
            }
            if (resourceURI != null && resourceURI.getScheme().equalsIgnoreCase("file")) {
                String resourcePath = rootURL.getPath();
                String rootPath = new File(resourcePath).getParentFile().getParent();
                computedRealPath = new File(rootPath, path).getAbsolutePath();
            } else if (resourceURL != null) {
                computedRealPath = new File(resourceURL.toURI()).getAbsolutePath();
            } else {
                String resourcePath = context.getRealPath("/");
                computedRealPath = new File(resourcePath, path).getAbsolutePath();
            }
            return URLDecoder.decode(computedRealPath, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new XFormsConfigException("path could not be resolved: " + path, e);
        }
        catch (URISyntaxException e) {
            throw new XFormsConfigException("path could not be resolved: " + path, e);
        }
        catch (MalformedURLException e) {
            throw new XFormsConfigException("path could not be resolved: " + path, e);
        }
    }
}

