/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web;

import de.betterform.agent.web.WebFactory;
import de.betterform.agent.web.WebUtil;
import de.betterform.agent.web.event.DefaultUIEventImpl;
import de.betterform.agent.web.event.UIEvent;
import de.betterform.agent.web.flux.FluxProcessor;
import de.betterform.agent.web.servlet.HttpRequestHandler;
import de.betterform.generator.UIGenerator;
import de.betterform.generator.XSLTGenerator;
import de.betterform.xml.config.Config;
import de.betterform.xml.config.XFormsConfigException;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.events.XMLEvent;
import de.betterform.xml.xforms.AbstractProcessorDecorator;
import de.betterform.xml.xforms.exception.XFormsException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.xml.sax.InputSource;

public class WebProcessor
extends AbstractProcessorDecorator {
    public static final String REQUEST_URI = "requestURI";
    public static final String REQUEST_URL = "requestURL";
    public static final String PATH_INFO = "pathInfo";
    public static final String QUERY_STRING = "queryString";
    public static final String CONTEXTROOT = "contextroot";
    public static final String SESSION_ID = "betterform.session.id";
    public static final String REALPATH = "webapp.realpath";
    public static final String XSL_PARAM_NAME = "xslt";
    public static final String ACTIONURL_PARAM_NAME = "action_url";
    public static final String UIGENERATOR = "betterform.UIGenerator";
    public static final String REFERER = "betterform.referer";
    public static final String FORWARD_URL = "betterform.base.url";
    public static final String ADAPTER_PREFIX = "A";
    public static final String REQUEST_PATH = "requestpath";
    public static final String RESOURCE_DIR = "WEB-INF/classes/META-INF/resources/";
    public static final String ALTERNATIVE_ROOT = "ResourcePath";
    String KEEPALIVE_PULSE = "keepalive";
    protected transient HttpRequestHandler httpRequestHandler;
    protected transient XMLEvent exitEvent = null;
    protected String contextRoot;
    private String key = null;
    protected transient HttpServletRequest request;
    protected transient HttpServletResponse response;
    protected transient HttpSession httpSession;
    protected transient ServletContext context;
    private static final Log LOGGER = LogFactory.getLog(FluxProcessor.class);
    protected String uploadDestination;
    protected String useragent;
    protected String uploadDir;
    protected transient UIGenerator uiGenerator;

    public void configure() throws XFormsException {
        this.initConfig();
        Cookie[] cookies = this.request.getCookies();
        List<Cookie> cookiesList = cookies != null ? Arrays.asList(this.request.getCookies()) : Collections.EMPTY_LIST;
        WebUtil.storeCookies(cookiesList, this);
        WebUtil.setContextParams(this.request, this.httpSession, this, this.getKey());
        WebUtil.copyHttpHeaders(this.request, this);
        this.setLocale();
        this.configureUpload();
    }

    public String getKey() {
        if (this.key == null) {
            this.key = this.generateXFormsSessionKey();
        }
        return this.key;
    }

    protected void setKey(String key) {
        LOGGER.debug((Object)("Settting key: " + key));
        this.key = key;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setHttpSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    public void setUseragent(String useragent) {
        this.useragent = useragent;
    }

    public void setXForms() throws XFormsException {
        if (this.xformsProcessor == null) {
            throw new XFormsException("Adapter has not yet been initialized");
        }
        if (this.request.getParameter("form") != null) {
            try {
                String formURI = WebUtil.getFormUrlAsString(this.request);
                this.xformsProcessor.setXForms(new URI(formURI));
                this.setBaseURI(formURI);
            }
            catch (URISyntaxException e) {
                throw new XFormsException("URI is malformed: " + e);
            }
            catch (MalformedURLException e) {
                throw new XFormsException("URL is malformed: " + e);
            }
            catch (UnsupportedEncodingException e) {
                throw new XFormsException("Encoding of form Url is not supported: " + e);
            }
        } else if (this.request.getAttribute("XFormsInputURI") != null) {
            String uri = (String)this.request.getAttribute("XFormsInputURI");
            try {
                this.xformsProcessor.setXForms(new URI(WebUtil.decodeUrl(uri, this.request)));
            }
            catch (URISyntaxException e) {
                throw new XFormsException("URI is malformed: " + e);
            }
            catch (UnsupportedEncodingException e) {
                throw new XFormsException("Encoding of form Url is not supported: " + e);
            }
        } else if (this.request.getAttribute("XFormsInputNode") != null) {
            Node node = (Node)this.request.getAttribute("XFormsInputNode");
            this.xformsProcessor.setXForms(node);
        } else if (this.request.getAttribute("XFormsInputStream") != null) {
            InputStream inputStream = (InputStream)this.request.getAttribute("XFormsInputStream");
            this.xformsProcessor.setXForms(inputStream);
        } else if (this.request.getAttribute("XFormsInputSource") != null) {
            InputSource inputSource = (InputSource)this.request.getAttribute("XFormsInputSource");
            this.xformsProcessor.setXForms(inputSource);
        } else {
            throw new XFormsException("no XForms input document found - init failed");
        }
        if (this.configuration.getProperty("webprocessor.doIncludes").equals("true")) {
            this.doIncludes();
        }
    }

    public void setLocale() throws XFormsException {
        if (Config.getInstance().getProperty("enable.l10n").equals("true")) {
            if (this.request.getParameter("lang") != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("using 'lang' Url parameter: " + this.request.getParameter("lang")));
                }
                this.setLocale(this.request.getParameter("lang"));
            } else if ((String)this.request.getAttribute("lang") != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("using request Attribute 'lang': " + this.request.getParameter("lang")));
                }
                this.setLocale((String)this.request.getAttribute("lang"));
            } else if (StringUtils.isNotBlank((CharSequence)Config.getInstance().getProperty("preselect-language"))) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("using configured lang setting from Config: " + Config.getInstance().getProperty("preselect-language")));
                }
                this.setLocale(Config.getInstance().getProperty("preselect-language"));
            } else if (this.request.getHeader("accept-language") != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("using accept-language header: " + this.request.getHeader("accept-language")));
                }
                this.setLocale(this.request.getLocale().getLanguage());
            }
        } else {
            this.setLocale("en");
        }
    }

    public ServletContext getContext() {
        if (this.context != null) {
            return this.context;
        }
        if (this.httpSession != null) {
            return this.httpSession.getServletContext();
        }
        return null;
    }

    public void setContext(ServletContext context) {
        this.context = context;
    }

    @Override
    public void init() throws XFormsException {
        this.configuration = Config.getInstance();
        this.addEventListeners();
        this.xformsProcessor.init();
    }

    public XMLEvent checkForExitEvent() {
        return this.exitEvent;
    }

    public void handleUIEvent(UIEvent event) throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Event " + event.getEventName() + " dispatched"));
            LOGGER.debug((Object)("Event target: " + event.getId()));
        }
    }

    @Override
    public void handleEvent(Event event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Handling Event " + event.getType()));
        }
    }

    public void setUploadDestination(String destination) {
        this.uploadDestination = destination;
    }

    public synchronized void handleRequest() throws XFormsException {
        boolean updating = false;
        WebUtil.nonCachingResponse(this.response);
        try {
            XMLEvent exitEvent;
            if (this.request.getMethod().equalsIgnoreCase("POST") && this.request.getAttribute("betterform.init-by-post") == null && this.request.getAttribute("org.exist.forward") == null) {
                updating = true;
                DefaultUIEventImpl uiEvent = new DefaultUIEventImpl();
                uiEvent.initEvent("http-request", null, this.request);
                this.handleUIEvent(uiEvent);
            }
            if ((exitEvent = this.checkForExitEvent()) != null) {
                this.handleExit(exitEvent);
            } else {
                String referer = null;
                if (updating) {
                    referer = (String)this.getContextParam(REFERER);
                    this.setContextParam("update", "true");
                    String forwardTo = this.request.getContextPath() + "/view?sessionKey=" + this.getKey() + "&referer=" + referer;
                    this.response.sendRedirect(this.response.encodeRedirectURL(forwardTo));
                } else {
                    referer = this.request.getQueryString();
                    String userAgent = this.request.getHeader("User-Agent");
                    String xuaCompatible = this.request.getHeader("X-UA-Compatible");
                    if (xuaCompatible == null && (userAgent.contains("IE8") || userAgent.contains("MSIE 8"))) {
                        this.response.addHeader("X-UA-Compatible", "IE8");
                    } else if (xuaCompatible == null && (userAgent.contains("IE9") || userAgent.contains("MSIE 9"))) {
                        this.response.addHeader("X-UA-Compatible", "IE9");
                    }
                    this.response.setContentType("text/html;charset=UTF-8");
                    this.createUIGenerator();
                    this.setContextParam(REFERER, this.request.getContextPath() + this.request.getServletPath() + "?" + referer);
                    if (this.request.isRequestedSessionIdValid()) {
                        this.httpSession.setAttribute("TimeStamp", (Object)System.currentTimeMillis());
                    }
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"WebProcessor: Begin Form: \n");
                        DOMUtil.prettyPrintDOM(this.xformsProcessor.getXForms());
                        LOGGER.debug((Object)"\nWebProcessor: End Form");
                    }
                    this.generateUI(this.xformsProcessor.getXForms(), outputStream);
                    this.response.setContentLength(outputStream.toByteArray().length);
                    this.response.getOutputStream().write(outputStream.toByteArray());
                }
            }
        }
        catch (IOException e) {
            throw new XFormsException(e);
        }
        catch (URISyntaxException e) {
            throw new XFormsException(e);
        }
        WebUtil.printSessionKeys(this.httpSession);
    }

    protected void generateUI(Object input, Object output) throws XFormsException {
        this.uiGenerator.setInput(input);
        this.uiGenerator.setOutput(output);
        this.uiGenerator.generate();
    }

    public void handleExit(XMLEvent exitEvent) throws IOException {
        if ("betterform-replace-all".equals(exitEvent.getType())) {
            this.response.sendRedirect(this.response.encodeRedirectURL(this.request.getContextPath() + "/" + "submissionResponse" + "?sessionKey=" + this.getKey()));
        } else if ("betterform-replace-all-xforms".equals(exitEvent.getType())) {
            WebUtil.removeSession(this.getKey());
            this.response.sendRedirect(this.response.encodeRedirectURL((String)exitEvent.getContextInfo("redirectXForms")));
        } else if ("betterform-load-uri".equals(exitEvent.getType()) && exitEvent.getContextInfo("show") != null) {
            String loadURI = (String)exitEvent.getContextInfo("uri");
            WebUtil.removeSession(this.getKey());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("loading: " + loadURI));
            }
            this.response.sendRedirect(this.response.encodeRedirectURL(loadURI));
        }
        LOGGER.debug((Object)"************************* EXITED DURING XFORMS MODEL INIT *************************");
    }

    public void close(Exception e) throws IOException {
        if (this.xformsProcessor != null) {
            try {
                this.xformsProcessor.shutdown();
            }
            catch (XFormsException xfe) {
                LOGGER.error((Object)("Message: " + xfe.getMessage() + " Cause: " + xfe.getCause()));
            }
        }
        this.httpSession.setAttribute("betterform.exception", (Object)e);
        WebUtil.removeSession(this.getKey());
        this.response.sendRedirect(this.response.encodeRedirectURL(this.request.getContextPath() + "/" + this.configuration.getProperty("error.page")));
    }

    protected void initConfig() throws XFormsException {
        String initParameter = this.getContext().getInitParameter("betterform.configfile");
        String configPath = WebFactory.getRealPath(initParameter, this.getContext());
        if (configPath != null && !configPath.equals("")) {
            this.xformsProcessor.setConfigPath(configPath);
            this.configuration = Config.getInstance();
        }
    }

    private String generateXFormsSessionKey() {
        StringBuffer key = new StringBuffer(String.valueOf(System.currentTimeMillis()));
        key.append(String.valueOf(Math.random()));
        return DigestUtils.sha512Hex((String)key.toString());
    }

    protected HttpRequestHandler getHttpRequestHandler() {
        if (this.httpRequestHandler == null) {
            this.httpRequestHandler = new HttpRequestHandler(this);
            this.httpRequestHandler.setUploadRoot(this.uploadDestination);
            this.httpRequestHandler.setSessionKey(this.getKey());
        }
        return this.httpRequestHandler;
    }

    private URI getTransformURI() throws XFormsException, URISyntaxException {
        String xslFile = this.request.getParameter(XSL_PARAM_NAME);
        String xsltPath = "WEB-INF/classes/META-INF/resources/xslt";
        if (xslFile != null) {
            return new File(WebFactory.getRealPath(xsltPath, this.getContext())).toURI().resolve(new URI(xslFile));
        }
        Element e = this.xformsProcessor.getXForms().getDocumentElement();
        if (e.hasAttributeNS("http://betterform.sourceforge.net/xforms", "transform")) {
            String transformValue = e.getAttributeNS("http://betterform.sourceforge.net/xforms", "transform");
            return new URI(WebUtil.getRequestURI(this.request) + transformValue);
        }
        String configuredTransform = this.configuration.getProperty("ui-transform");
        if (configuredTransform != null) {
            return new File(WebFactory.getRealPath(xsltPath, this.getContext())).toURI().resolve(new URI(configuredTransform));
        }
        throw new XFormsConfigException("There was no xslt stylesheet found on the request URI, the root element of the form or in the configfile");
    }

    protected void createUIGenerator() throws URISyntaxException, XFormsException {
        String relativeUris = this.configuration.getProperty("forms.uri.relative");
        URI uri = this.getTransformURI();
        XSLTGenerator generator = WebFactory.setupTransformer(uri, this.getContext());
        generator.setParameter("sessionKey", this.getKey());
        generator.setParameter("baseURI", this.getBaseURI());
        String realPath = WebFactory.getRealPath("/", this.context);
        generator.setParameter("realPath", realPath);
        generator.setParameter("locale", this.locale);
        generator.setParameter("user-agent", this.request.getHeader("User-Agent"));
        generator.setParameter("action-url", this.getActionURL());
        if (relativeUris.equals("true")) {
            generator.setParameter(CONTEXTROOT, ".");
        } else {
            generator.setParameter(CONTEXTROOT, WebUtil.getContextRoot(this.request));
        }
        if (this.getContextParam(this.KEEPALIVE_PULSE) != null) {
            generator.setParameter("keepalive-pulse", this.getContextParam(this.KEEPALIVE_PULSE));
        }
        generator.setParameter("debug-enabled", String.valueOf(this.configuration.getProperty("betterform.debug-allowed").equals("true")));
        generator.setParameter("unloadingMessage", this.configuration.getProperty("betterform.unloading-message"));
        String selectorPrefix = Config.getInstance().getProperty("betterform.web.selectorPrefix", "s_");
        generator.setParameter("selector-prefix", selectorPrefix);
        String removeUploadPrefix = Config.getInstance().getProperty("betterform.web.removeUploadPrefix", "ru_");
        generator.setParameter("remove-upload-prefix", removeUploadPrefix);
        String dataPrefix = Config.getInstance().getProperty("betterform.web.dataPrefix");
        generator.setParameter("data-prefix", dataPrefix);
        String triggerPrefix = Config.getInstance().getProperty("betterform.web.triggerPrefix");
        generator.setParameter("trigger-prefix", triggerPrefix);
        this.uiGenerator = generator;
        this.setContextParam(UIGENERATOR, this.uiGenerator);
    }

    private void doIncludes() {
        try {
            Document input = this.getXForms();
            String xsltPath = "WEB-INF/classes/META-INF/resources/xslt/";
            URI styleURI = new File(WebFactory.getRealPath(xsltPath, this.getContext())).toURI().resolve(new URI("include.xsl"));
            XSLTGenerator xsltGenerator = WebFactory.setupTransformer(styleURI, this.getContext());
            String baseURI = this.getBaseURI();
            String uri = baseURI.substring(0, baseURI.lastIndexOf("/") + 1);
            xsltGenerator.setParameter("root", uri);
            DOMResult result = new DOMResult();
            DOMSource source = new DOMSource(input);
            xsltGenerator.setInput(source);
            xsltGenerator.setOutput(result);
            xsltGenerator.generate();
            this.setXForms(result.getNode());
        }
        catch (XFormsException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private String getActionURL() {
        String actionURL;
        String defaultActionURL = this.request.getRequestURI();
        String encodedDefaultActionURL = this.response.encodeURL(defaultActionURL);
        int sessIdx = encodedDefaultActionURL.indexOf(";jsession");
        String sessionId = null;
        if (sessIdx > -1) {
            sessionId = encodedDefaultActionURL.substring(sessIdx);
        }
        if (null == (actionURL = this.request.getParameter(ACTIONURL_PARAM_NAME))) {
            actionURL = encodedDefaultActionURL;
        } else if (null != sessionId) {
            actionURL = actionURL + sessionId;
        }
        LOGGER.debug((Object)("actionURL: " + actionURL));
        actionURL = this.response.encodeURL(actionURL);
        return actionURL;
    }

    private void configureUpload() throws XFormsConfigException {
        this.uploadDir = Config.getInstance().getProperty("uploadDir");
        if (this.uploadDir == null) {
            throw new XFormsConfigException("upload dir is not set in betterform-config.xml");
        }
        if (!new File(this.uploadDir).isAbsolute()) {
            this.uploadDir = WebFactory.getRealPath(this.uploadDir, this.getContext());
        }
        this.setUploadDestination(new File(this.uploadDir).getAbsolutePath());
    }

    private boolean noHttp() {
        return this.request == null || this.response == null || this.httpSession == null;
    }
}

