/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.cache;

import de.betterform.agent.web.flux.FluxProcessor;
import de.betterform.xml.config.XFormsConfigException;
import de.betterform.xml.xforms.exception.XFormsException;
import java.io.IOException;
import org.infinispan.Cache;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.DefaultCacheManager;

public class XFSessionCache {
    private static Cache<String, FluxProcessor> XFSESSIONCACHE;
    private static DefaultCacheManager cacheManager;
    private static String DEFAULT_CACHE;

    protected XFSessionCache() {
    }

    protected static void initCache(String cacheName) throws IOException {
        cacheManager = new DefaultCacheManager("infinispan.xml");
        XFSESSIONCACHE = cacheManager.getCache(cacheName);
    }

    public static Cache<String, FluxProcessor> getCache() throws XFormsConfigException {
        if (XFSESSIONCACHE == null) {
            try {
                XFSessionCache.initCache(DEFAULT_CACHE);
            }
            catch (IOException e) {
                throw new XFormsConfigException("Cache configuration broken or missing on classpath");
            }
        }
        return XFSESSIONCACHE;
    }

    public static Cache<String, FluxProcessor> getCache(String cacheName) throws XFormsConfigException {
        try {
            XFSessionCache.initCache(cacheName);
        }
        catch (IOException e) {
            throw new XFormsConfigException("infinispan.xml file not found");
        }
        return XFSESSIONCACHE;
    }

    public static void unloadCache() {
        if (XFSESSIONCACHE != null) {
            ComponentStatus status = XFSESSIONCACHE.getStatus();
            if (status.equals((Object)ComponentStatus.RUNNING)) {
                XFSESSIONCACHE.stop();
            }
            cacheManager.stop();
            XFSESSIONCACHE = null;
        }
    }

    public static void main(String[] argv) {
        try {
            Cache<String, FluxProcessor> cache = XFSessionCache.getCache();
        }
        catch (XFormsException xfce) {
            System.err.println("Booooooooooooooooooooooooooooo!");
        }
    }

    static {
        DEFAULT_CACHE = "xfSessionCache";
    }
}

