/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.filter;

import de.betterform.agent.web.WebUtil;
import de.betterform.agent.web.filter.BufferedServletOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.http.HeaderElement;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.HeaderValueParser;

public class BufferedHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    private ByteArrayOutputStream output = new ByteArrayOutputStream();
    private ServletOutputStream servletOutputStream = null;
    private PrintWriter printWriter = null;
    private boolean usingOutputStream = false;
    private boolean usingWriter = false;
    private int contentLength;
    private boolean buffered = false;

    public BufferedHttpServletResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public byte[] getData() {
        try {
            if (this.servletOutputStream != null) {
                this.servletOutputStream.flush();
            }
            if (this.printWriter != null) {
                this.printWriter.flush();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return this.output.toByteArray();
    }

    public String getDataAsString() throws UnsupportedEncodingException {
        return new String(this.getData(), this.getCharacterEncoding());
    }

    private ServletOutputStream getInternalOutputStream() throws IOException {
        if (this.shouldBuffer()) {
            this.buffered = true;
            return new BufferedServletOutputStream(this.output);
        }
        return super.getOutputStream();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.usingWriter) {
            throw new IllegalStateException("getWriter() has already been called for this response");
        }
        this.usingOutputStream = true;
        if (this.servletOutputStream == null) {
            this.servletOutputStream = this.getInternalOutputStream();
        }
        return this.servletOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.usingOutputStream) {
            throw new IllegalStateException("getOutputStream() has already been called for this response");
        }
        this.setCharacterEncoding(this.getCharacterEncoding());
        this.usingWriter = true;
        if (this.printWriter == null) {
            if (this.servletOutputStream == null) {
                this.servletOutputStream = this.getInternalOutputStream();
            }
            this.printWriter = new PrintWriter((OutputStream)this.servletOutputStream);
        }
        return this.printWriter;
    }

    public void setContentLength(int length) {
        this.contentLength = length;
        super.setContentLength(length);
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void flushBuffer() throws IOException {
        if (this.servletOutputStream != null) {
            this.servletOutputStream.flush();
        }
        if (this.printWriter != null) {
            this.printWriter.flush();
        }
    }

    public String getMediaType() {
        String strContentType = this.getContentType();
        String strMediaType = null;
        String strSubType = null;
        if (strContentType == null) {
            return "";
        }
        HeaderElement[] aHeaderelementTmp = BasicHeaderValueParser.parseElements((String)strContentType, (HeaderValueParser)new BasicHeaderValueParser());
        if (aHeaderelementTmp.length >= 1) {
            StringTokenizer stringtokenizerTmp = new StringTokenizer(aHeaderelementTmp[0].getName());
            if (stringtokenizerTmp.hasMoreTokens()) {
                strMediaType = stringtokenizerTmp.nextToken("/");
            }
            if (stringtokenizerTmp.hasMoreTokens()) {
                strSubType = stringtokenizerTmp.nextToken("/;");
            }
        }
        if (strMediaType != null && strSubType != null) {
            return (strMediaType + "/" + strSubType).toLowerCase();
        }
        return "";
    }

    public boolean hasXMLContentType() {
        String result = this.getMediaType();
        if ("".equals(result)) {
            return false;
        }
        boolean isXML = false;
        return WebUtil.isMediaTypeXML(result);
    }

    private boolean shouldBuffer() {
        String contentType = this.getResponse().getContentType();
        if (contentType != null) {
            if (contentType.contains(";")) {
                contentType = contentType.substring(0, contentType.indexOf(";"));
            }
            return "text/html".equalsIgnoreCase(contentType) || this.hasXMLContentType();
        }
        return true;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.getData());
    }

    public void debugPrint() {
        try {
            int x;
            InputStream inputStream = this.getInputStream();
            while ((x = inputStream.read()) != -1) {
                System.out.print((char)x);
            }
            inputStream.reset();
        }
        catch (IOException ex) {
            System.out.println("WARNING: Caught Exception while Reading from input stream in BufferedHttpServletResponse!");
        }
    }

    public boolean isBuffered() {
        return this.buffered;
    }
}

