/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.filter;

import de.betterform.agent.web.WebFactory;
import de.betterform.agent.web.filter.CharResponseWrapper;
import de.betterform.generator.XSLTGenerator;
import de.betterform.xml.config.XFormsConfigException;
import de.betterform.xml.xforms.exception.XFormsException;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XSLTFilter
implements Filter {
    private static final Log LOG = LogFactory.getLog(XSLTFilter.class);
    private FilterConfig filterConfig = null;
    private String xsltPath;
    private String xslFile;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.xsltPath = filterConfig.getInitParameter("xsltHome");
        this.xslFile = filterConfig.getInitParameter("xsltFile");
    }

    public void destroy() {
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        ServletContext servletContext = this.filterConfig.getServletContext();
        String stylePath = null;
        try {
            stylePath = WebFactory.getRealPath(this.xsltPath, servletContext);
        }
        catch (XFormsConfigException e) {
            throw new ServletException((Throwable)e);
        }
        File styleFile = new File(stylePath, this.xslFile);
        PrintWriter out = response.getWriter();
        CharResponseWrapper wrapper = new CharResponseWrapper((HttpServletResponse)response);
        try {
            URI uri = new File(WebFactory.getRealPath(this.xsltPath, servletContext)).toURI().resolve(new URI(this.xslFile));
            XSLTGenerator generator = WebFactory.setupTransformer(uri, servletContext);
            wrapper.setContentType("text/html");
            chain.doFilter(request, (ServletResponse)wrapper);
            StringReader sr = new StringReader(wrapper.toString());
            generator.setInput(sr);
            CharArrayWriter caw = new CharArrayWriter();
            generator.setOutput(caw);
            generator.generate();
            response.setContentLength(caw.toString().length());
            out.write(caw.toString());
        }
        catch (URISyntaxException e) {
            out.println(e.toString());
            out.write(wrapper.toString());
        }
        catch (XFormsException e) {
            out.println(e.toString());
            out.write(wrapper.toString());
        }
    }
}

