/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.flux;

import de.betterform.agent.web.flux.FluxException;
import de.betterform.agent.web.flux.FluxUtil;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.exception.XFormsException;
import java.io.ByteArrayOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.WebContextFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FluxModel {
    private static final Log LOGGER = LogFactory.getLog(FluxModel.class);
    private HttpSession session = WebContextFactory.get().getSession(true);
    private HttpServletRequest request = WebContextFactory.get().getHttpServletRequest();
    private HttpServletResponse response = WebContextFactory.get().getHttpServletResponse();

    public static Element getInstanceDocument(String modelId, String instanceId, String sessionKey) {
        try {
            return FluxUtil.getProcessor(sessionKey, WebContextFactory.get().getHttpServletRequest(), WebContextFactory.get().getHttpServletResponse(), WebContextFactory.get().getSession(true)).getXFormsModel(modelId).getInstanceDocument(instanceId).getDocumentElement();
        }
        catch (XFormsException e) {
            return DOMUtil.newDocument(false, false).getDocumentElement();
        }
        catch (FluxException e) {
            return DOMUtil.newDocument(false, false).getDocumentElement();
        }
    }

    public String getInstanceAsString(String modelId, String instanceId, String sessionKey) {
        Element element = null;
        try {
            element = FluxUtil.getProcessor(sessionKey, this.request, this.response, this.session).getXFormsModel(modelId).getInstanceDocument(instanceId).getDocumentElement();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DOMUtil.prettyPrintDOM((Node)element, out);
            LOGGER.debug((Object)("xml: " + StringEscapeUtils.escapeXml((String)out.toString())));
            return StringEscapeUtils.escapeXml((String)out.toString());
        }
        catch (XFormsException e) {
            e.printStackTrace();
        }
        catch (FluxException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return "";
    }

    public void rebuild(String modelId, String sessionKey) throws FluxException {
        try {
            FluxUtil.getProcessor(sessionKey, this.request, this.response, this.session).getXFormsModel(modelId).rebuild();
        }
        catch (XFormsException e) {
            throw new FluxException(e);
        }
    }

    public void recalculate(String modelId, String sessionKey) throws FluxException {
        try {
            FluxUtil.getProcessor(sessionKey, this.request, this.response, this.session).getXFormsModel(modelId).recalculate();
        }
        catch (XFormsException e) {
            throw new FluxException(e);
        }
    }

    public void revalidate(String modelId, String sessionKey) throws FluxException {
        try {
            FluxUtil.getProcessor(sessionKey, this.request, this.response, this.session).getXFormsModel(modelId).revalidate();
        }
        catch (XFormsException e) {
            throw new FluxException(e);
        }
    }

    public void refresh(String modelId, String sessionKey) throws FluxException {
        try {
            FluxUtil.getProcessor(sessionKey, this.request, this.response, this.session).getXFormsModel(modelId).refresh();
        }
        catch (XFormsException e) {
            throw new FluxException(e);
        }
    }
}

