/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.flux;

import de.betterform.agent.web.WebProcessor;
import de.betterform.agent.web.WebUtil;
import de.betterform.agent.web.event.DefaultUIEventImpl;
import de.betterform.agent.web.event.EventQueue;
import de.betterform.agent.web.event.UIEvent;
import de.betterform.agent.web.flux.FluxException;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.events.XMLEvent;
import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.ui.BindingElement;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;

public class FluxProcessor
extends WebProcessor
implements Externalizable {
    private static final Log LOGGER = LogFactory.getLog(FluxProcessor.class);
    public static final String FLUX_ACTIVATE_EVENT = "flux-action-event";
    private transient EventQueue eventQueue = new EventQueue();
    private static final long serialVersionUID = 2L;

    public EventQueue getEventQueue() {
        return this.eventQueue;
    }

    @Override
    public void init() throws XFormsException {
        super.init();
        if (this.checkForExitEvent() != null) {
            return;
        }
        this.root.addEventListener("betterform-state-changed", this, true);
        this.root.addEventListener("betterform-prototype-cloned", this, true);
        this.root.addEventListener("betterform-id-generated", this, true);
        this.root.addEventListener("betterform-item-inserted", this, true);
        this.root.addEventListener("betterform-item-deleted", this, true);
        this.root.addEventListener("betterform-item-changed", this, true);
        this.root.addEventListener("betterform-index-changed", this, true);
        this.root.addEventListener("betterform-switch-toggled", this, true);
        this.root.addEventListener("betterform-AVT-changed", this, true);
        if ("true".equals(this.getXForms().getDocumentElement().getAttribute("bf:serialized"))) {
            this.getXForms().getDocumentElement().removeAttribute("bf:serialized");
        }
    }

    public void dispatchEvent(String id) throws XFormsException, FluxException {
        DefaultUIEventImpl uiActivateEvent = new DefaultUIEventImpl();
        uiActivateEvent.initEvent(FLUX_ACTIVATE_EVENT, id, null);
        this.handleUIEvent(uiActivateEvent);
    }

    @Override
    public void handleUIEvent(UIEvent uiEvent) throws XFormsException {
        super.handleUIEvent(uiEvent);
        this.eventQueue.flush();
        String targetId = uiEvent.getId();
        if (uiEvent.getEventName().equalsIgnoreCase(FLUX_ACTIVATE_EVENT)) {
            this.dispatch(targetId, "DOMActivate");
        } else if (uiEvent.getEventName().equalsIgnoreCase("SETINDEX")) {
            int index = Integer.parseInt((String)uiEvent.getContextInfo());
            this.setRepeatIndex(targetId, index);
        } else if (uiEvent.getEventName().equalsIgnoreCase("SETVALUE")) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Event contextinfo: " + uiEvent.getContextInfo()));
            }
            this.setControlValue(targetId, (String)uiEvent.getContextInfo());
        } else if (uiEvent.getEventName().equalsIgnoreCase("http-request")) {
            HttpServletRequest request = (HttpServletRequest)uiEvent.getContextInfo();
            this.getHttpRequestHandler().handleUpload(request);
        } else if (uiEvent.getEventName().equalsIgnoreCase("SETLOCALE")) {
            this.setLocale(uiEvent.getContextInfo().toString());
        } else {
            throw new XFormsException("Unknown or illegal uiEvent type");
        }
    }

    @Override
    public void handleEvent(Event event) {
        super.handleEvent(event);
        try {
            if (event instanceof XMLEvent) {
                XMLEvent xmlEvent = (XMLEvent)event;
                String type = xmlEvent.getType();
                if ("betterform-replace-all".equals(type) || "betterform-replace-all-xforms".equals(type)) {
                    HashMap<String, Object> submissionResponse = new HashMap<String, Object>();
                    submissionResponse.put("header", xmlEvent.getContextInfo("header"));
                    submissionResponse.put("body", xmlEvent.getContextInfo("body"));
                    this.xformsProcessor.setContextParam("betterform.submission.response", submissionResponse);
                    xmlEvent.addProperty("webcontext", (String)this.getContextParam("contextroot"));
                    this.eventQueue.add(xmlEvent);
                    this.exitEvent = xmlEvent;
                    this.shutdown();
                    return;
                }
                if ("betterform-load-uri".equals(type)) {
                    String show = (String)xmlEvent.getContextInfo("show");
                    if ("embed".equals(show)) {
                        Element targetElement = (Element)xmlEvent.getContextInfo("targetElement");
                        StringWriter result = new StringWriter();
                        this.generateUI(targetElement, result);
                        xmlEvent.addProperty("targetElement", result.toString());
                    }
                    this.eventQueue.add(xmlEvent);
                    if ("replace".equals(show)) {
                        this.exitEvent = xmlEvent;
                        this.shutdown();
                        WebUtil.removeSession(this.getKey());
                    }
                    return;
                }
                if ("betterform-state-changed".equals(type)) {
                    Element target = (Element)((Object)event.getTarget());
                    String targetId = target.getAttributeNS(null, "id");
                    String targetName = target.getLocalName();
                    String dataType = (String)xmlEvent.getContextInfo("type");
                    if (dataType == null) {
                        XFormsElement control = this.lookup(targetId);
                        if (EventQueue.HELPER_ELEMENTS.contains(targetName)) {
                            String parentId = ((Element)target.getParentNode()).getAttributeNS(null, "id");
                            xmlEvent.addProperty("parentId", parentId);
                        } else if (control instanceof BindingElement) {
                            Element bfData;
                            if (LOGGER.isDebugEnabled()) {
                                DOMUtil.prettyPrintDOM(control.getElement());
                            }
                            if ((bfData = DOMUtil.getChildElement(control.getElement(), "bf:data")) != null) {
                                String internalType = bfData.getAttributeNS("http://betterform.sourceforge.net/xforms", "type");
                                xmlEvent.addProperty("type", internalType);
                            }
                        }
                    }
                    this.eventQueue.add(xmlEvent);
                    return;
                }
                if ("xforms-version-exception".equals(type)) {
                    WebUtil.removeSession(this.getKey());
                    xmlEvent.addProperty("errorinformation", xmlEvent.getContextInfo().get("error-information"));
                }
                this.eventQueue.add(xmlEvent);
            }
        }
        catch (Exception e) {
            this.handleEventException(e);
        }
    }

    private Map copyMap(Map generatedIds) {
        HashMap tmpMap = new HashMap(generatedIds.size());
        for (Object key : generatedIds.keySet()) {
            tmpMap.put(key, generatedIds.get(key));
        }
        return tmpMap;
    }

    @Override
    public void shutdown() throws XFormsException {
        if (this.root != null) {
            this.root.removeEventListener("betterform-state-changed", this, true);
            this.root.removeEventListener("betterform-prototype-cloned", this, true);
            this.root.removeEventListener("betterform-id-generated", this, true);
            this.root.removeEventListener("betterform-item-inserted", this, true);
            this.root.removeEventListener("betterform-item-deleted", this, true);
            this.root.removeEventListener("betterform-item-changed", this, true);
            this.root.removeEventListener("betterform-index-changed", this, true);
            this.root.removeEventListener("betterform-switch-toggled", this, true);
            this.root.removeEventListener("betterform-AVT-changed", this, true);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("writeExternal this = " + this.xformsProcessor.getBaseURI()));
        }
        this.xformsProcessor.writeExternal(objectOutput);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.xformsProcessor.readExternal(objectInput);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("readExternal this = " + this.xformsProcessor.getBaseURI()));
        }
    }

    public boolean equals(Object that) {
        LOGGER.debug((Object)"equals");
        if (that instanceof FluxProcessor) {
            return this.getKey().equals(((FluxProcessor)that).getKey());
        }
        return false;
    }
}

