/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.resources;

import de.betterform.agent.web.WebFactory;
import de.betterform.agent.web.resources.stream.DefaultResourceStreamer;
import de.betterform.agent.web.resources.stream.ResourceStreamer;
import de.betterform.xml.config.XFormsConfigException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog(ResourceServlet.class);
    private static Map<String, String> mimeTypes;
    private List<ResourceStreamer> resourceStreamers;
    private boolean caching;
    private boolean exploded = false;
    private long oneYear = 31363200000L;
    public static final String RESOURCE_FOLDER = "/META-INF/resources";
    public static final String RESOURCE_PATTERN = "bfResources";
    private long lastModified = 0L;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if ("false".equals(config.getInitParameter("caching"))) {
            this.caching = false;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Caching of Resources is disabled");
            }
        } else {
            this.caching = true;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Caching of Resources is enabled - resources are loaded from classpath");
            }
        }
        this.lastModified = this.getLastModifiedValue();
        String path = null;
        try {
            path = WebFactory.getRealPath("WEB-INF/classes/META-INF/resources", config.getServletContext());
        }
        catch (XFormsConfigException e) {
            throw new ServletException((Throwable)e);
        }
        if (path != null && new File(path).exists()) {
            this.exploded = true;
        }
        this.initMimeTypes();
        this.initResourceStreamers();
    }

    private void initMimeTypes() {
        mimeTypes = new HashMap<String, String>();
        mimeTypes.put("css", "text/css");
        mimeTypes.put("js", "text/javascript");
        mimeTypes.put("jpg", "image/jpeg");
        mimeTypes.put("jpeg", "image/jpeg");
        mimeTypes.put("png", "image/png");
        mimeTypes.put("gif", "image/gif");
        mimeTypes.put("gif", "image/gif");
        mimeTypes.put("html", "text/html");
        mimeTypes.put("swf", "application/x-shockwave-flash");
        mimeTypes.put("xsl", "application/xml+xslt");
    }

    private void initResourceStreamers() {
        this.resourceStreamers = new ArrayList<ResourceStreamer>();
        this.resourceStreamers.add(new DefaultResourceStreamer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String requestUri = req.getRequestURI();
        String resourcePath = RESOURCE_FOLDER + this.getResourcePath(requestUri);
        URL url = ResourceServlet.class.getResource(resourcePath);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Request URI: " + requestUri));
            LOG.trace((Object)("resource fpath: " + resourcePath));
        }
        if (url == null) {
            boolean error = true;
            if (requestUri.endsWith(".js") && requestUri.contains("scripts/betterform/betterform-") && ResourceServlet.class.getResource(resourcePath) == null && ResourceServlet.class.getResource(resourcePath = resourcePath.replace("betterform-", "BfRequired")) != null) {
                error = false;
            }
            if (error) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Resource " + resourcePath + " not found"));
                }
                resp.sendError(404, "Resource " + resourcePath + " not found");
                return;
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Streaming resource " + resourcePath));
        }
        InputStream inputStream = null;
        try {
            if (this.exploded) {
                String path = ResourceServlet.class.getResource(resourcePath).getPath();
                inputStream = new FileInputStream(new File(path));
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("loading reources form file: " + path));
                }
            } else {
                inputStream = ResourceServlet.class.getResourceAsStream(resourcePath);
            }
            String mimeType = this.getResourceContentType(resourcePath);
            if (mimeType == null) {
                mimeType = this.getServletContext().getMimeType(resourcePath);
            }
            if (mimeType == null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("MimeType for " + resourcePath + " not found. Sending 'not found' response"));
                }
                resp.sendError(415, "MimeType for " + resourcePath + " not found. Sending 'not found' response");
                return;
            }
            resp.setContentType(mimeType);
            resp.setStatus(200);
            this.setCaching(req, resp);
            this.streamResource(req, resp, mimeType, inputStream);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Resource " + resourcePath + " streamed succesfully"));
            }
        }
        catch (Exception exception) {
            LOG.error((Object)("Error in streaming resource " + resourcePath + ". Exception is " + exception.getMessage()));
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            resp.getOutputStream().flush();
            resp.getOutputStream().close();
        }
    }

    private void streamResource(HttpServletRequest req, HttpServletResponse resp, String mimeType, InputStream inputStream) throws IOException {
        for (ResourceStreamer streamer : this.resourceStreamers) {
            if (!streamer.isAppropriateStreamer(mimeType)) continue;
            streamer.stream(req, resp, inputStream);
        }
    }

    protected void setCaching(HttpServletRequest request, HttpServletResponse response) {
        long now = System.currentTimeMillis();
        if (this.caching) {
            response.setHeader("Cache-Control", "max-age=3600, public");
            response.setDateHeader("Date", now);
            response.setDateHeader("Expires", now + this.oneYear);
            response.setDateHeader("Last-Modified", this.getLastModifiedValue());
        } else {
            response.setHeader("Expires", "Sat, 6 May 1995 12:00:00 GMT");
            response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
            response.addHeader("Cache-Control", "post-check=0, pre-check=0");
            response.setHeader("Pragma", "no-cache");
        }
    }

    protected String getResourcePath(String requestURI) {
        int jsessionidIndex = requestURI.toLowerCase().indexOf(";jsessionid");
        if (jsessionidIndex != -1) {
            requestURI = requestURI.substring(0, jsessionidIndex);
        }
        int patternIndex = requestURI.indexOf(RESOURCE_PATTERN);
        return requestURI.substring(patternIndex + RESOURCE_PATTERN.length(), requestURI.length());
    }

    protected String getResourceContentType(String resourcePath) {
        String resourceFileExtension = this.getResourceFileExtension(resourcePath);
        return mimeTypes.get(resourceFileExtension);
    }

    protected String getResourceFileExtension(String resourcePath) {
        String[] parsed = resourcePath.split("\\.");
        return parsed[parsed.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLastModifiedValue() {
        if (this.lastModified == 0L) {
            long bfTimestamp;
            try {
                String path = WebFactory.getRealPath("/WEB-INF/betterform-version.info", this.getServletContext());
                StringBuilder versionInfo = new StringBuilder();
                String NL = System.getProperty("line.separator");
                try (Scanner scanner = new Scanner((InputStream)new FileInputStream(path), "UTF-8");){
                    while (scanner.hasNextLine()) {
                        versionInfo.append(scanner.nextLine() + NL);
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("VersionInfo: " + versionInfo));
                }
                String timestamp = versionInfo.substring(versionInfo.indexOf("Timestamp:") + 10, versionInfo.length());
                String df = "yyyy-MM-dd HH:mm:ss";
                SimpleDateFormat sdf = new SimpleDateFormat(df);
                Date date = sdf.parse(timestamp);
                bfTimestamp = date.getTime();
            }
            catch (Exception e) {
                LOG.error((Object)"Error setting HTTP Header 'Last Modified', could not parse the given date.");
                bfTimestamp = 0L;
            }
            this.lastModified = bfTimestamp;
        }
        return this.lastModified;
    }

    protected long getLastModified(HttpServletRequest req) {
        return this.getLastModifiedValue();
    }
}

