/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.servlet;

import de.betterform.agent.web.WebUtil;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.util.PositionalXMLReader;
import de.betterform.xml.xforms.exception.XFormsErrorIndication;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ErrorServlet
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(ErrorServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Exception ex;
        int start;
        WebUtil.nonCachingResponse(response);
        String xpath = "unknown";
        String cause = "";
        String msg = (String)this.getSessionAttribute(request, "betterform.exception.message");
        if (msg != null && (start = msg.indexOf("::")) > 3) {
            xpath = msg.substring(start + 2);
            msg = msg.substring(0, start);
        }
        if ((ex = (Exception)this.getSessionAttribute(request, "betterform.exception")) != null && ex.getCause() != null && ex.getCause().getMessage() != null) {
            cause = ex.getCause().getMessage();
        }
        Element rootNode = DOMUtil.createRootElement("error");
        DOMUtil.appendElement(rootNode, "context", request.getContextPath());
        DOMUtil.appendElement(rootNode, "url", request.getSession().getAttribute("betterform.referer").toString());
        DOMUtil.appendElement(rootNode, "xpath", xpath);
        DOMUtil.appendElement(rootNode, "message", msg);
        DOMUtil.appendElement(rootNode, "cause", cause);
        if (ex instanceof XFormsErrorIndication) {
            HashMap map;
            Object o = ((XFormsErrorIndication)ex).getContextInfo();
            if (o instanceof HashMap && (map = (HashMap)((XFormsErrorIndication)ex).getContextInfo()).size() != 0) {
                Element contextinfo = rootNode.getOwnerDocument().createElement("contextInfo");
                rootNode.appendChild(contextinfo);
                for (Map.Entry entry : map.entrySet()) {
                    DOMUtil.appendElement(rootNode, (String)entry.getKey(), entry.getValue().toString());
                }
            }
            Document hostDoc = (Document)this.getSessionAttribute(request, "betterform.hostDoc");
            String serializedDoc = DOMUtil.serializeToString(hostDoc);
            try {
                byte[] bytes = serializedDoc.getBytes("UTF-8");
                Document newDoc = PositionalXMLReader.readXML(new ByteArrayInputStream(bytes));
                DOMUtil.prettyPrintDOM(newDoc);
                Node n = XPathUtil.evaluateAsSingleNode(newDoc, xpath);
                String linenumber = (String)n.getUserData("lineNumber");
                DOMUtil.appendElement(rootNode, "lineNumber", linenumber);
                WebUtil.doTransform(this.getServletContext(), response, newDoc, "highlightError.xsl", rootNode);
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
            finally {
                try {
                    if (LOGGER.isErrorEnabled()) {
                        ByteArrayOutputStream messageBuf = new ByteArrayOutputStream();
                        DOMUtil.prettyPrintDOM((Node)rootNode, messageBuf);
                        LOGGER.error((Object)messageBuf.toString());
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)msg, (Throwable)e);
                }
            }
        } else {
            WebUtil.doTransform(this.getServletContext(), response, rootNode.getOwnerDocument(), "error.xsl", null);
        }
    }

    private Object getSessionAttribute(HttpServletRequest request, String sessionVar) {
        Object o = request.getSession().getAttribute(sessionVar);
        request.getSession().removeAttribute(sessionVar);
        return o;
    }
}

