/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.servlet;

import de.betterform.agent.web.WebFactory;
import de.betterform.agent.web.servlet.FormsServlet;
import de.betterform.agent.web.utils.SortingWalker;
import de.betterform.xml.config.XFormsConfigException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileStoreServlet
extends FormsServlet {
    protected boolean showFiles = false;
    protected boolean recursive = false;
    protected boolean filterReadOnly = false;
    protected int total = 0;

    @Override
    public void init() throws ServletException {
        super.init();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getParameter("path");
        String query = request.getParameter("query");
        if (path == null) {
            path = "forms";
        }
        if (query != null) {
            String[] queryOptions = query.substring(query.indexOf(123) + 1, query.indexOf(125)).split(",");
            for (int i = 0; i < queryOptions.length; ++i) {
                if (queryOptions[i].contains("deep")) {
                    this.recursive = Boolean.parseBoolean(queryOptions[i].substring(queryOptions[i].indexOf(58) + 1));
                    continue;
                }
                if (queryOptions[i].contains("files")) {
                    this.showFiles = Boolean.parseBoolean(queryOptions[i].substring(queryOptions[i].indexOf(58) + 1));
                    continue;
                }
                if (!queryOptions[i].contains("filterReadOnly")) continue;
                this.filterReadOnly = Boolean.parseBoolean(queryOptions[i].substring(queryOptions[i].indexOf(58) + 1));
            }
        }
        String listing = null;
        try {
            listing = this.handleFileListing(path);
        }
        catch (XFormsConfigException e) {
            throw new ServletException((Throwable)e);
        }
        String tmp = "{\n'total':" + this.total + ",\n'items':[" + listing + "\n]\n}";
        response.getOutputStream().write(tmp.getBytes());
        response.flushBuffer();
        this.total = 0;
    }

    private String handleFileListing(String path) throws IOException, XFormsConfigException {
        String readDir = null;
        String root = null;
        String rootDir = null;
        StringBuffer listing = new StringBuffer();
        root = WebFactory.getRealPath(".", this.getServletConfig().getServletContext());
        rootDir = root != null && root.endsWith("/") ? root + "/" : "/";
        readDir = rootDir + path;
        File filesroot = new File(readDir);
        if (filesroot.exists()) {
            List<File> files = SortingWalker.sortDirsAndFiles(filesroot);
            File f = null;
            if (files != null) {
                for (File aFile : files) {
                    if (this.ignores.contains(aFile.getName()) || !(f = new File(readDir + "/" + aFile.getName())).isDirectory() || aFile.getName().startsWith(".")) continue;
                    listing.append(this.listDirectory(aFile));
                }
                if (this.showFiles) {
                    for (File aFile : files) {
                        if (this.ignores.contains(aFile.getName()) || !(f = new File(readDir + "/" + aFile.getName())).isFile() || aFile.getName().startsWith(".")) continue;
                        listing.append(this.listFile(aFile));
                    }
                }
            }
        }
        return listing.toString();
    }

    protected String listDirectory(File directory) throws IOException {
        if (directory.canWrite() || !this.filterReadOnly) {
            ++this.total;
            if (this.recursive) {
                return "{'name': '" + directory.getName() + "', 'parentDir': '" + directory.getParent() + "', 'size': 0000, 'modified':" + directory.lastModified() + ", 'directory': true, 'path': '" + directory.getPath() + "', 'children': [" + this.listChildren(directory) + "]},";
            }
            return "{'name': '" + directory.getName() + "', 'parentDir': '" + directory.getParent() + "', 'size': 0000, 'modified':" + directory.lastModified() + ", 'directory': true, 'path': '" + directory.getPath() + "'},";
        }
        return "";
    }

    protected String listFile(File file) {
        if (file.canWrite() || !this.filterReadOnly) {
            ++this.total;
            return "{'name': '" + file.getName() + "', 'parentDir': '" + file.getParent() + "', 'size': " + file.length() + ", 'modified':" + file.lastModified() + ", 'directory': false, 'path': '" + file.getPath() + "'},";
        }
        return "";
    }

    protected String listChildren(File directory) throws IOException {
        List<File> files = SortingWalker.sortDirsAndFiles(directory);
        StringBuffer listing = new StringBuffer();
        if (files != null) {
            for (File file : files) {
                if (this.ignores.contains(file.getName()) || !file.isDirectory() || file.getName().startsWith(".")) continue;
                listing.append(this.listDirectory(file));
            }
            if (this.showFiles) {
                for (File file : files) {
                    if (this.ignores.contains(file.getName()) || !file.isFile() || file.getName().startsWith(".")) continue;
                    listing.append(this.listFile(file));
                }
            }
        }
        return listing.toString();
    }
}

