/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.servlet;

import de.betterform.agent.web.servlet.compositecontrols.CompositeControlFactory;
import de.betterform.agent.web.servlet.compositecontrols.CompositeControlValue;
import de.betterform.agent.web.upload.MonitoredDiskFileItemFactory;
import de.betterform.agent.web.upload.UploadInfo;
import de.betterform.agent.web.upload.UploadListener;
import de.betterform.xml.config.Config;
import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.XFormsProcessor;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.ui.AbstractFormControl;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpRequestHandler {
    private static final Log LOGGER = LogFactory.getLog(HttpRequestHandler.class);
    public static final String DATA_PREFIX_PROPERTY = "betterform.web.dataPrefix";
    public static final String TRIGGER_PREFIX_PROPERTY = "betterform.web.triggerPrefix";
    public static final String SELECTOR_PREFIX_PROPERTY = "betterform.web.selectorPrefix";
    public static final String REMOVE_UPLOAD_PREFIX_PROPERTY = "betterform.web.removeUploadPrefix";
    public static final String DAYTIMEDURATION_PREFIX_PROPERTY = "betterform.web.dayTimeDurationPrefix";
    public static final String DATETIME_PREFIX_PROPERTY = "betterform.web.dateTimePrefix";
    public static final String DATA_PREFIX_DEFAULT = "d_";
    public static final String TRIGGER_PREFIX_DEFAULT = "t_";
    public static final String SELECTOR_PREFIX_DEFAULT = "s_";
    public static final String REMOVE_UPLOAD_PREFIX_DEFAULT = "ru_";
    private String removeUploadPrefix;
    private XFormsProcessor xformsProcessor;
    private String uploadRoot;
    private String sessionKey;
    private String dataPrefix;
    private String selectorPrefix;
    private String triggerPrefix;
    private HashMap compositeControlValues = new HashMap();

    public HttpRequestHandler(XFormsProcessor aXFormsProcessor) {
        this.xformsProcessor = aXFormsProcessor;
    }

    public void setUploadRoot(String uploadRoot) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Upload will be stored to: " + uploadRoot));
        }
        this.uploadRoot = uploadRoot;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public void handleRequest(HttpServletRequest request) throws XFormsException {
        Map[] parameters;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("handle request: " + request.getRequestURI()));
        }
        try {
            parameters = this.parseRequest(request);
        }
        catch (Exception e) {
            throw new XFormsException("could not parse request", e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("parameter: " + parameters[0]));
        }
        if (parameters[0] != null) {
            this.processUploadParameters(parameters[0], request);
        }
        if (parameters[1] != null) {
            this.processControlParameters(parameters[1]);
        }
        if (parameters[2] != null) {
            this.processRepeatParameters(parameters[2]);
        }
        if (parameters[3] != null) {
            this.processTriggerParameters(parameters[3]);
        }
    }

    public void handleUpload(HttpServletRequest request) throws XFormsException {
        Map[] parameters;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("handle request: " + request.getRequestURI()));
        }
        try {
            parameters = this.parseRequest(request);
        }
        catch (Exception e) {
            throw new XFormsException("could not parse request", e);
        }
        if (parameters[0] != null) {
            this.processUploadParameters(parameters[0], request);
        }
    }

    protected Map[] parseRequest(HttpServletRequest request) throws FileUploadException, UnsupportedEncodingException {
        Map[] parameters = new Map[4];
        if (FileUpload.isMultipartContent((RequestContext)new ServletRequestContext(request))) {
            UploadListener uploadListener = new UploadListener(request, this.sessionKey);
            MonitoredDiskFileItemFactory factory = new MonitoredDiskFileItemFactory(uploadListener);
            factory.setRepository(new File(this.uploadRoot));
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            String encoding = request.getCharacterEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            for (FileItem item : upload.parseRequest(request)) {
                if (LOGGER.isDebugEnabled()) {
                    if (item.isFormField()) {
                        LOGGER.debug((Object)("request param: " + item.getFieldName() + " - value='" + item.getString() + "'"));
                    } else {
                        LOGGER.debug((Object)("file in request: " + item.getName()));
                    }
                }
                this.parseMultiPartParameter(item, encoding, parameters);
            }
        } else {
            Enumeration enumeration = request.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                String[] values = request.getParameterValues(name);
                this.parseURLEncodedParameter(name, values, parameters);
            }
        }
        return parameters;
    }

    protected void parseURLEncodedParameter(String name, String[] values, Map[] parameters) {
        if (name.startsWith(this.getDataPrefix()) || name.startsWith("c_")) {
            StringBuffer buffer = new StringBuffer(values[0]);
            for (int index = 1; index < values.length; ++index) {
                buffer.append(" ").append(values[index]);
            }
            parameters[1] = this.parseControlParameter(name, buffer.toString().trim(), parameters[1]);
        } else if (name.startsWith(this.getSelectorPrefix())) {
            parameters[2] = this.parseRepeatParameter(name, values[0], parameters[2]);
        } else if (name.startsWith(this.getTriggerPrefix())) {
            parameters[3] = this.parseTriggerParameter(name, values[0], parameters[3]);
        }
    }

    protected void parseMultiPartParameter(FileItem item, String encoding, Map[] parameters) throws UnsupportedEncodingException {
        String name = item.getFieldName();
        if (name.startsWith(this.getDataPrefix()) || name.startsWith("c_")) {
            if (item.isFormField()) {
                parameters[1] = this.parseControlParameter(name, item.getString(encoding), parameters[1]);
            } else {
                parameters[0] = this.parseUploadParameter(name, item, parameters[0]);
            }
        } else if (name.startsWith(this.getSelectorPrefix())) {
            parameters[2] = this.parseRepeatParameter(name, item.getString(encoding), parameters[2]);
        } else if (name.startsWith(this.getTriggerPrefix())) {
            parameters[3] = this.parseTriggerParameter(name, item.getString(encoding), parameters[3]);
        }
    }

    protected Map parseUploadParameter(String name, FileItem item, Map uploads) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Upload param-name: " + name));
            LOGGER.debug((Object)("Upload item size: " + item.getSize() + " bytes"));
        }
        if (uploads == null) {
            uploads = new HashMap<String, FileItem>();
        }
        String id = name.substring(this.getDataPrefix().length());
        uploads.put(id, item);
        return uploads;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Map parseControlParameter(String name, String value, Map controls) {
        String list;
        if (controls == null) {
            controls = new HashMap();
        }
        String id = null;
        if (name.startsWith("c_")) {
            id = name.substring(name.lastIndexOf(95) + 1);
            CompositeControlValue ccValue = (CompositeControlValue)this.compositeControlValues.get(id);
            if (ccValue == null) {
                ccValue = CompositeControlFactory.createCompositeControl(name);
            }
            ccValue.setPart(name, value);
            if (!ccValue.isComplete()) {
                this.compositeControlValues.put(id, ccValue);
                return controls;
            }
            value = ccValue.toString();
            this.compositeControlValues.remove(id);
        } else {
            id = name.substring(this.getDataPrefix().length());
        }
        list = (list = (String)controls.get(id)) == null ? value : list.concat(" ").concat(value).trim();
        controls.put(id, list);
        return controls;
    }

    protected Map parseRepeatParameter(String name, String value, Map repeats) {
        if (repeats == null) {
            repeats = new HashMap<String, String>();
        }
        int separator = value.lastIndexOf(58);
        String id = value.substring(0, separator);
        String index = value.substring(separator + 1);
        repeats.put(id, index);
        return repeats;
    }

    protected Map parseTriggerParameter(String name, String value, Map trigger) {
        int y;
        String id;
        int x;
        if (trigger == null) {
            trigger = new HashMap<String, String>();
        }
        if ((x = (id = name.substring(this.getTriggerPrefix().length())).lastIndexOf(".x")) > -1) {
            id = id.substring(0, x);
        }
        if ((y = id.lastIndexOf(".y")) > -1) {
            id = id.substring(0, y);
        }
        trigger.put(id, "DOMActivate");
        return trigger;
    }

    protected void processUploadParameters(Map uploads, HttpServletRequest request) throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("updating " + uploads.keySet().size() + " uploads(s)"));
        }
        try {
            for (String id : uploads.keySet()) {
                FileItem item = (FileItem)uploads.get(id);
                if (item.getSize() > 0L) {
                    byte[] data;
                    LOGGER.debug((Object)"i'm here");
                    if (this.xformsProcessor.isFileUpload(id, "anyURI")) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)"found upload type 'anyURI'");
                        }
                        String localPath = new StringBuffer().append(System.currentTimeMillis()).append('/').append(item.getName()).toString();
                        File localFile = new File(this.uploadRoot, localPath);
                        localFile.getParentFile().mkdirs();
                        item.write(localFile);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("saving data to path: " + localFile));
                        }
                        File uploadDir = new File(request.getContextPath(), Config.getInstance().getProperty("uploadDir"));
                        String urlEncodedPath = URLEncoder.encode(new File(uploadDir.getPath(), localPath).getPath(), "UTF-8");
                        URI uploadTargetDir = new URI(urlEncodedPath);
                        data = uploadTargetDir.toString().getBytes();
                    } else {
                        data = item.get();
                    }
                    this.xformsProcessor.setUploadValue(id, item.getContentType(), item.getName(), data);
                    request.getSession().setAttribute("A" + this.sessionKey + "-uploadInfo", (Object)new UploadInfo(1, 0L, 0L, 0L, "done"));
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("ignoring empty upload " + id));
                }
                item.delete();
            }
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
    }

    protected void processControlParameters(Map controls) throws XFormsException {
        int all;
        int changed;
        String value;
        Iterator iterator = controls.keySet().iterator();
        int unchanged = 0;
        while (iterator.hasNext()) {
            String id = (String)iterator.next();
            if (this.hasControlChanged(id, value = (String)controls.get(id))) continue;
            controls.put(id, null);
            ++unchanged;
        }
        if (LOGGER.isDebugEnabled() && (changed = (all = controls.keySet().size()) - unchanged) > 0) {
            LOGGER.debug((Object)("updating " + changed + " of " + all + " control(s)"));
        }
        for (String id : controls.keySet()) {
            value = (String)controls.get(id);
            if (value == null) continue;
            this.xformsProcessor.setControlValue(id, value);
        }
    }

    private final boolean hasControlChanged(String id, String value) throws XFormsException {
        XFormsElement element = this.xformsProcessor.lookup(id);
        if (element == null || !(element instanceof AbstractFormControl)) {
            throw new XFormsException("id '" + id + "' does not identify a form control");
        }
        AbstractFormControl control = (AbstractFormControl)element;
        Object controlValue = control.getValue();
        if (controlValue == null) {
            return false;
        }
        return !controlValue.equals(value);
    }

    protected void processRepeatParameters(Map repeats) throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("updating " + repeats.keySet().size() + " repeat(s)"));
        }
        for (String id : repeats.keySet()) {
            int index = Integer.parseInt((String)repeats.get(id));
            this.xformsProcessor.setRepeatIndex(id, index);
        }
    }

    protected void processTriggerParameters(Map trigger) throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("activating " + trigger.keySet().size() + " trigger"));
        }
        for (String id : trigger.keySet()) {
            String event = (String)trigger.get(id);
            this.xformsProcessor.dispatch(id, event);
        }
    }

    protected final String getTriggerPrefix() {
        if (this.triggerPrefix == null) {
            try {
                this.triggerPrefix = Config.getInstance().getProperty(TRIGGER_PREFIX_PROPERTY, TRIGGER_PREFIX_DEFAULT);
            }
            catch (Exception e) {
                this.triggerPrefix = TRIGGER_PREFIX_DEFAULT;
            }
        }
        return this.triggerPrefix;
    }

    protected final String getDataPrefix() {
        if (this.dataPrefix == null) {
            try {
                this.dataPrefix = Config.getInstance().getProperty(DATA_PREFIX_PROPERTY, DATA_PREFIX_DEFAULT);
            }
            catch (Exception e) {
                this.dataPrefix = DATA_PREFIX_DEFAULT;
            }
        }
        return this.dataPrefix;
    }

    protected final String getRemoveUploadPrefix() {
        if (this.removeUploadPrefix == null) {
            try {
                this.removeUploadPrefix = Config.getInstance().getProperty(REMOVE_UPLOAD_PREFIX_PROPERTY, REMOVE_UPLOAD_PREFIX_DEFAULT);
            }
            catch (Exception e) {
                this.removeUploadPrefix = REMOVE_UPLOAD_PREFIX_DEFAULT;
            }
        }
        return this.removeUploadPrefix;
    }

    protected final String getSelectorPrefix() {
        if (this.selectorPrefix == null) {
            try {
                this.selectorPrefix = Config.getInstance().getProperty(SELECTOR_PREFIX_PROPERTY, SELECTOR_PREFIX_DEFAULT);
            }
            catch (Exception e) {
                this.selectorPrefix = SELECTOR_PREFIX_DEFAULT;
            }
        }
        return this.selectorPrefix;
    }
}

