/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.servlet;

import de.betterform.agent.web.WebProcessor;
import de.betterform.agent.web.event.UIEvent;
import de.betterform.xml.events.XMLEvent;
import de.betterform.xml.xforms.exception.XFormsException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class PlainHtmlProcessor
extends WebProcessor
implements EventListener {
    private static final Log LOGGER = LogFactory.getLog(PlainHtmlProcessor.class);

    @Override
    public void init() throws XFormsException {
        super.init();
    }

    @Override
    public void handleUIEvent(UIEvent event) throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("PlainHtmlProcessor.handleUIEvent event: " + event.getEventName()));
        }
        super.handleUIEvent(event);
        if (event.getEventName().equalsIgnoreCase("http-request")) {
            HttpServletRequest request = (HttpServletRequest)event.getContextInfo();
            this.getHttpRequestHandler().handleRequest(request);
        } else {
            LOGGER.warn((Object)("ignoring unknown event '" + event.getEventName() + "'"));
        }
    }

    @Override
    public void handleEvent(Event event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("PlainHtmlProcessor.handleEvent event type: " + event.getType()));
        }
        super.handleEvent(event);
        try {
            if (event instanceof XMLEvent) {
                String show;
                XMLEvent xmlEvent = (XMLEvent)event;
                String type = xmlEvent.getType();
                if ("betterform-replace-all".equals(type) || "betterform-replace-all-xforms".equals(type)) {
                    HashMap<String, Object> submissionResponse = new HashMap<String, Object>();
                    submissionResponse.put("header", xmlEvent.getContextInfo("header"));
                    submissionResponse.put("body", xmlEvent.getContextInfo("body"));
                    this.xformsProcessor.setContextParam("betterform.submission.response", submissionResponse);
                    this.exitEvent = xmlEvent;
                    this.shutdown();
                } else if ("betterform-load-uri".equals(type) && "replace".equals(show = (String)xmlEvent.getContextInfo("show"))) {
                    this.exitEvent = xmlEvent;
                    this.shutdown();
                }
            }
        }
        catch (Exception e) {
            this.handleEventException(e);
        }
    }
}

