/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.servlet;

import de.betterform.agent.web.WebFactory;
import de.betterform.xml.config.XFormsConfigException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UploadServlet
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(UploadServlet.class);

    public String getServletInfo() {
        return "responsible for showing the views to the user in betterForm XForms applications";
    }

    public void destroy() {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String payload = "";
        try {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            List items = upload.parseRequest(request);
            Iterator iter = items.iterator();
            FileItem uploadItem = null;
            String collectionPath = "";
            String collectionName = "";
            String relativeUploadPath = "";
            while (iter.hasNext()) {
                FileItem item = (FileItem)iter.next();
                String fieldName = item.getFieldName();
                if (item.isFormField() && "bfUploadPath".equals(fieldName)) {
                    relativeUploadPath = this.getFieldValue(item);
                    continue;
                }
                if (item.isFormField() && "bfCollectionPath".equals(fieldName)) {
                    collectionPath = this.getFieldValue(item);
                    continue;
                }
                if (item.isFormField() && "bfCollectionName".equals(fieldName)) {
                    collectionName = this.getFieldValue(item);
                    continue;
                }
                if (item.getName() == null) continue;
                uploadItem = item;
            }
            if (uploadItem != null && !"".equals(relativeUploadPath)) {
                this.uploadFile(request, uploadItem, relativeUploadPath);
            } else if (!"".equals(collectionName) && !"".equals(collectionPath)) {
                this.createColection(request, collectionName, collectionPath);
            } else {
                LOGGER.warn((Object)("error uploading file to '" + relativeUploadPath + "'"));
            }
        }
        catch (FileUploadException e) {
            e.printStackTrace();
            payload = e.getMessage();
        }
        catch (Exception e) {
            e.printStackTrace();
            payload = e.getMessage();
        }
        response.getOutputStream().println("<html><body><textarea>" + payload + "</textarea></body></html>");
    }

    private void createColection(HttpServletRequest request, String collectionName, String collectionPath) throws XFormsConfigException {
        String realPath = WebFactory.getRealPath(".", request.getSession().getServletContext());
        File path2Collection = new File(realPath, collectionPath);
        File localFile = new File(path2Collection.getAbsolutePath(), collectionName);
        if (localFile.getParentFile().exists()) {
            boolean created = localFile.mkdir();
            if (created) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("collection '" + collectionName + "' created in directory '" + path2Collection.getAbsolutePath() + "'"));
                }
            } else {
                LOGGER.warn((Object)("collection'" + collectionName + "' could not be created in in directory '" + path2Collection.getAbsolutePath() + "'"));
            }
        } else {
            LOGGER.warn((Object)("Could not create collection " + collectionName + " because parent collection " + localFile.getParentFile().getAbsolutePath() + " does not exist"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFieldValue(FileItem item) throws IOException {
        InputStream is = item.getInputStream();
        if (is != null) {
            StringWriter writer = new StringWriter();
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                char[] buffer = new char[1024];
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return null;
    }

    private void uploadFile(HttpServletRequest request, FileItem uploadItem, String relativeUploadPath) throws Exception {
        File localFile;
        String realPath = WebFactory.getRealPath(".", request.getSession().getServletContext());
        File uploadDirectory = new File(realPath, relativeUploadPath);
        String fileName = uploadItem.getName();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("uploading file '" + fileName + "' to directory '" + uploadDirectory + "'"));
        }
        if (!(localFile = new File(uploadDirectory.getAbsolutePath(), fileName)).getParentFile().exists()) {
            localFile.getParentFile().mkdirs();
        }
        uploadItem.write(localFile);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("file '" + fileName + "' successfully uploaded to directory '" + uploadDirectory + "'"));
        }
    }
}

