/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.servlet;

import de.betterform.agent.web.WebProcessor;
import de.betterform.agent.web.WebUtil;
import de.betterform.generator.UIGenerator;
import de.betterform.xml.xforms.XFormsProcessor;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ViewServlet
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(ViewServlet.class);

    public String getServletInfo() {
        return "responsible for showing the views to the user in betterForm XForms applications";
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        XFormsProcessor webAdapter = null;
        HttpSession session = request.getSession(true);
        request.setCharacterEncoding("UTF-8");
        WebUtil.nonCachingResponse(response);
        String referer = request.getParameter("referer");
        WebProcessor webProcessor = WebUtil.getWebProcessor(request, response, session);
        try {
            if (webProcessor == null || webProcessor.getContextParam("update") == null) {
                LOGGER.info((Object)"session does not exist: creating new one");
                response.sendRedirect(response.encodeRedirectURL(referer));
            } else {
                webProcessor.removeContextParam("update");
                response.setContentType("text/html;charset=UTF-8");
                UIGenerator uiGenerator = (UIGenerator)webProcessor.getContextParam("betterform.UIGenerator");
                uiGenerator.setInput(webAdapter.getXForms());
                uiGenerator.setOutput(response.getOutputStream());
                uiGenerator.generate();
                response.getOutputStream().close();
            }
        }
        catch (Exception e) {
            webProcessor.close(e);
        }
    }
}

