/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.servlet;

import de.betterform.agent.web.WebFactory;
import de.betterform.agent.web.WebProcessor;
import de.betterform.agent.web.WebUtil;
import de.betterform.agent.web.flux.FluxProcessor;
import de.betterform.xml.config.XFormsConfigException;
import de.betterform.xml.xforms.AbstractProcessorDecorator;
import de.betterform.xml.xforms.exception.XFormsException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XFormsRepeater
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(XFormsRepeater.class);
    protected String contextRoot = null;
    protected String configPath;
    protected String useragent;
    private WebFactory webFactory;

    public String getServletInfo() {
        return "Servlet Controller for betterForm XForms Processor";
    }

    public void destroy() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"cleanups allocated resources");
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.useragent = config.getInitParameter("useragent");
        this.webFactory = new WebFactory();
        this.webFactory.setServletContext(this.getServletContext());
        try {
            this.webFactory.initConfiguration(this.useragent);
            this.webFactory.initLogging(((Object)((Object)this)).getClass());
            String realPath = WebFactory.getRealPath(".", this.getServletContext());
            this.webFactory.initTransformerService(realPath);
            this.webFactory.initXFormsSessionCache();
        }
        catch (XFormsConfigException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        WebUtil.nonCachingResponse(response);
        HttpSession session = null;
        session = request.getAttribute("Session") != null ? (HttpSession)request.getAttribute("Session") : request.getSession(true);
        request.setAttribute("useragent", (Object)this.useragent);
        System.out.println("request: " + request.getRequestURL().toString());
        if ("GET".equalsIgnoreCase(request.getMethod()) && request.getParameter("submissionResponse") != null) {
            this.doSubmissionReplaceAll(request, response);
        } else {
            this.processForm(request, response, session);
        }
    }

    protected void doSubmissionReplaceAll(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Log LOG = LogFactory.getLog(XFormsRepeater.class);
        HttpSession session = request.getSession(false);
        WebProcessor webProcessor = WebUtil.getWebProcessor(request, response, session);
        if (session != null && webProcessor != null) {
            Map submissionResponse;
            if (LOG.isDebugEnabled()) {
                Enumeration keys = session.getAttributeNames();
                if (keys.hasMoreElements()) {
                    LOG.debug((Object)"--- existing keys in session --- ");
                }
                while (keys.hasMoreElements()) {
                    String s = (String)keys.nextElement();
                    LOG.debug((Object)("existing sessionkey: " + s + ":" + session.getAttribute(s)));
                }
            }
            if ((submissionResponse = webProcessor.checkForExitEvent().getContextInfo()) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"handling submission/@replace='all'");
                    Enumeration keys = session.getAttributeNames();
                    if (keys.hasMoreElements()) {
                        LOG.debug((Object)"--- existing keys in http session  --- ");
                        while (keys.hasMoreElements()) {
                            String s = (String)keys.nextElement();
                            LOG.debug((Object)("existing sessionkey: " + s + ":" + session.getAttribute(s)));
                        }
                    } else {
                        LOG.debug((Object)"--- no keys left in http session  --- ");
                    }
                }
                Map headerMap = (Map)submissionResponse.get("header");
                for (String name : headerMap.keySet()) {
                    if (name.equalsIgnoreCase("Transfer-Encoding")) continue;
                    String value = (String)headerMap.get(name);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("added header: " + name + "=" + value));
                    }
                    response.setHeader(name, value);
                }
                InputStream bodyStream = (InputStream)submissionResponse.get("body");
                BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
                int b = bodyStream.read();
                while (b > -1) {
                    ((OutputStream)outputStream).write(b);
                    b = bodyStream.read();
                }
                bodyStream.close();
                ((OutputStream)outputStream).close();
                WebUtil.removeSession(webProcessor.getKey());
                return;
            }
        }
        response.sendError(403, "no submission response available");
    }

    private void processForm(HttpServletRequest request, HttpServletResponse response, HttpSession session) throws ServletException {
        block5: {
            String url = request.getRequestURL().toString();
            ServletContext context = this.getServletContext();
            if (request.getAttribute("XFormsInputStream") != null) {
                System.out.println("Request has an extra Stream!: ");
                System.out.println("Context: " + context.getServletContextName());
                System.out.println("Original Request URL: " + request.getAttribute("betterform.base.url"));
                url = (String)request.getAttribute("betterform.base.url");
            }
            FluxProcessor webProcessor = null;
            try {
                webProcessor = new FluxProcessor();
                webProcessor.setRequest(request);
                webProcessor.setResponse(response);
                webProcessor.setHttpSession(session);
                webProcessor.setBaseURI(url);
                webProcessor.setContext(context);
                webProcessor.configure();
                webProcessor.setXForms();
                ((WebProcessor)webProcessor).init();
                webProcessor.handleRequest();
            }
            catch (Exception e) {
                if (webProcessor == null) break block5;
                try {
                    ((AbstractProcessorDecorator)webProcessor).shutdown();
                }
                catch (XFormsException xFormsException) {
                    // empty catch block
                }
                session.setAttribute("betterform.exception", (Object)e);
                request.setAttribute("betterform.exception", (Object)e);
                request.setAttribute("betterform.referer", (Object)request.getRequestURL().toString());
                session.setAttribute("betterform.referer", (Object)request.getRequestURL().toString());
                WebUtil.removeSession(webProcessor.getKey());
                throw new ServletException((Throwable)e);
            }
        }
    }
}

