/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.servlet;

import de.betterform.agent.web.WebFactory;
import de.betterform.agent.web.WebUtil;
import de.betterform.xml.config.XFormsConfigException;
import de.betterform.xml.dom.DOMUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XFormsRequestServlet
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(XFormsRequestServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Document doc;
        LOGGER.debug((Object)"hit XFormsRequestServlet");
        request.setCharacterEncoding("UTF-8");
        WebUtil.nonCachingResponse(response);
        String formURI = WebUtil.getFormUrlAsString(request);
        if (formURI.startsWith("http://")) {
            InputStream inputStream = new URL(formURI).openStream();
            try {
                doc = DOMUtil.parseInputStream(inputStream, true, false);
            }
            catch (ParserConfigurationException e) {
                throw new ServletException((Throwable)e);
            }
            catch (SAXException e) {
                throw new ServletException((Throwable)e);
            }
        }
        String realPath = null;
        try {
            realPath = WebFactory.getRealPath(formURI, this.getServletContext());
        }
        catch (XFormsConfigException e) {
            throw new ServletException((Throwable)e);
        }
        File xfDoc = new File(realPath);
        try {
            doc = DOMUtil.parseXmlFile(xfDoc, true, false);
        }
        catch (ParserConfigurationException e) {
            throw new ServletException((Throwable)e);
        }
        catch (SAXException e) {
            throw new ServletException((Throwable)e);
        }
        request.setAttribute("XFormsInputNode", (Object)doc);
        response.getOutputStream().close();
    }
}

