/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.servlet;

import de.betterform.agent.web.WebFactory;
import de.betterform.agent.web.WebProcessor;
import de.betterform.agent.web.WebUtil;
import de.betterform.agent.web.flux.FluxProcessor;
import de.betterform.xml.config.XFormsConfigException;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XFormsServlet
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(XFormsServlet.class);
    protected String contextRoot = null;
    protected String configPath;
    protected String useragent;
    private WebFactory webFactory;

    public String getServletInfo() {
        return "Servlet Controller for betterForm XForms Processor";
    }

    public void destroy() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"cleanups allocated resources");
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.useragent = config.getInitParameter("useragent");
        this.webFactory = new WebFactory();
        this.webFactory.setServletContext(this.getServletContext());
        try {
            this.webFactory.initConfiguration(this.useragent);
            this.webFactory.initLogging(((Object)((Object)this)).getClass());
            String realPath = WebFactory.getRealPath(".", this.getServletContext());
            this.webFactory.initTransformerService(realPath);
            this.webFactory.initXFormsSessionCache();
        }
        catch (XFormsConfigException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block2: {
            request.setCharacterEncoding("UTF-8");
            WebUtil.nonCachingResponse(response);
            HttpSession session = request.getSession(true);
            request.setAttribute("useragent", (Object)this.useragent);
            FluxProcessor webProcessor = null;
            try {
                webProcessor = new FluxProcessor();
                webProcessor.setRequest(request);
                webProcessor.setResponse(response);
                webProcessor.setHttpSession(session);
                webProcessor.setBaseURI(request.getRequestURL().toString());
                webProcessor.configure();
                webProcessor.setXForms();
                ((WebProcessor)webProcessor).init();
                webProcessor.handleRequest();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (webProcessor == null) break block2;
                webProcessor.close(e);
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setAttribute("XFormsInputStream", (Object)req.getInputStream());
        req.setAttribute("betterform.init-by-post", (Object)true);
        this.doGet(req, resp);
    }
}

