/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.servlet;

import de.betterform.agent.web.WebFactory;
import de.betterform.xml.config.XFormsConfigException;
import de.betterform.xml.dom.DOMUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class XSLTServlet
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(XSLTServlet.class);
    private String editorHome;
    private String xslFile;
    public static final String defContentType = "text/html; charset=UTF-8";
    public static final String contentTypeHTML = "text/html; charset=UTF-8";
    public static final String errorTemplate = "+++ERRORS+++";
    private static HashMap cache;

    public String getServletInfo() {
        return "responsible for showing the views to the user in betterForm XForms applications";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.editorHome = config.getInitParameter("editorHome");
        this.xslFile = config.getInitParameter("xsltFile");
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletContext servletContext = this.getServletContext();
        String stylePath = null;
        try {
            stylePath = WebFactory.getRealPath(this.editorHome, servletContext);
        }
        catch (XFormsConfigException e) {
            throw new ServletException((Throwable)e);
        }
        File styleFile = new File(stylePath, this.xslFile);
        if (styleFile == null) {
            throw new ServletException("XSL stylesheet cannot be found: " + styleFile);
        }
        String contentType = null;
        Object doc = null;
        Object xsl = null;
        contentType = (String)request.getAttribute("contenttype");
        if (contentType == null) {
            contentType = "text/html; charset=UTF-8";
        }
        response.setContentType(contentType);
        if (cache == null) {
            cache = new HashMap();
        }
        Transformer t = null;
        String inputFile = request.getPathTranslated();
        File input = new File(inputFile);
        if (input == null) {
            throw new ServletException("XML document cannot be found: " + inputFile);
        }
        StreamSource xmlSource = new StreamSource(new FileInputStream(input));
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            StreamSource xslSource = new StreamSource(new FileInputStream(styleFile));
            t = tFactory.newTransformer(xslSource);
            String contextName = request.getContextPath();
            t.setParameter("APP_CONTEXT", contextName);
            t.setParameter("EDITOR_HOME", stylePath.substring(stylePath.indexOf("/betterform/")) + "/");
            t.setParameter("filename", "file://" + inputFile);
            Document resultDoc = DOMUtil.newDocument(true, false);
            t.transform(xmlSource, new DOMResult(resultDoc));
            request.setAttribute("XFormsInputNode", (Object)resultDoc);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    private StringBuffer generateError(String error) throws IOException, XFormsConfigException {
        String path = WebFactory.getRealPath("forms/incubator/editor", this.getServletContext());
        File f = new File(path, "callerror.html");
        FileInputStream fs = new FileInputStream(f);
        BufferedInputStream bis = new BufferedInputStream(fs);
        int numBytes = bis.available();
        byte[] b = new byte[numBytes];
        bis.read(b);
        StringBuffer buf = new StringBuffer();
        buf.append(b);
        int start = buf.indexOf(errorTemplate);
        int end = start + errorTemplate.length();
        buf.replace(start, end, error);
        return buf;
    }
}

