/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.upload;

import de.betterform.agent.web.upload.OutputStreamListener;
import de.betterform.agent.web.upload.UploadInfo;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UploadListener
implements OutputStreamListener {
    private static final Log LOGGER = LogFactory.getLog(UploadListener.class);
    private HttpServletRequest request;
    private long delay = 0L;
    private long startTime = 0L;
    private int totalToRead = 0;
    private int totalBytesRead = 0;
    private int totalFiles = -1;
    private String sessionKey;

    public UploadListener(HttpServletRequest request, String sessionKey) {
        this.request = request;
        this.delay = 0L;
        this.totalToRead = request.getContentLength();
        this.startTime = System.currentTimeMillis();
        this.sessionKey = sessionKey;
    }

    @Override
    public void start() {
        ++this.totalFiles;
        this.updateUploadInfo("start");
    }

    @Override
    public void bytesRead(int bytesRead) {
        this.totalBytesRead += bytesRead;
        this.updateUploadInfo("progress");
        try {
            Thread.sleep(this.delay);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void error(String message) {
        this.updateUploadInfo("error");
    }

    @Override
    public void done() {
    }

    private long getDelta() {
        return (System.currentTimeMillis() - this.startTime) / 1000L;
    }

    private void updateUploadInfo(String status) {
        long delta = (System.currentTimeMillis() - this.startTime) / 1000L;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("status: " + status));
            LOGGER.debug((Object)("Bytes read: " + this.totalBytesRead));
        }
        this.request.getSession().setAttribute("A" + this.sessionKey + "-uploadInfo", (Object)new UploadInfo(this.totalFiles, this.totalToRead, this.totalBytesRead, delta, status));
    }
}

