/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.NameFileComparator;

public class SortingWalker
extends DirectoryWalker {
    private String[] fileExtensions = null;
    private boolean recursive = false;
    private int depthLimit = -1;
    private Comparator defaultComparator = NameFileComparator.NAME_INSENSITIVE_COMPARATOR;

    private SortingWalker(int depth) {
        super(null, depth);
        this.depthLimit = depth;
    }

    private SortingWalker(int depth, String[] fileExtensions) {
        super(null, depth);
        this.depthLimit = depth;
        this.fileExtensions = fileExtensions;
    }

    protected boolean handleDirectory(File directory, int depth, Collection results) {
        if (depth == 0) {
            return true;
        }
        if (this.depthLimit >= depth) {
            results.add(directory);
            return true;
        }
        return false;
    }

    protected void handleFile(File directory, int depth, Collection results) {
    }

    public static List<File> sortDirsAndFiles(File directory) throws IOException {
        return SortingWalker.sortDirsAndFiles(directory, 1, null);
    }

    public static List<File> sortDirsAndFiles(File directory, String[] fileExtensions) throws IOException {
        return SortingWalker.sortDirsAndFiles(directory, 1, fileExtensions);
    }

    private static List<File> sortDirsAndFiles(File directory, int depth, String[] fileExtensions) throws IOException {
        SortingWalker walker = new SortingWalker(depth, fileExtensions);
        return walker.sortDir(directory);
    }

    private List<File> sortDir(File root) throws IOException {
        ArrayList resultDirectoriesList = new ArrayList();
        ArrayList<File> results = new ArrayList<File>();
        this.walk(root, resultDirectoriesList);
        Collections.sort(resultDirectoriesList, this.defaultComparator);
        results.addAll(resultDirectoriesList);
        results.addAll(this.sortFilesInDir(root));
        return results;
    }

    private List sortFilesInDir(File directory) {
        ArrayList list = new ArrayList(FileUtils.listFiles((File)directory, (String[])this.fileExtensions, (boolean)this.recursive));
        Collections.sort(list, this.defaultComparator);
        return list;
    }
}

