/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector;

import de.betterform.connector.Connector;
import de.betterform.connector.InstanceSerializer;
import de.betterform.connector.InstanceSerializerMap;
import de.betterform.connector.SchemaValidator;
import de.betterform.connector.serializer.SerializerRequestWrapper;
import de.betterform.connector.util.URIUtil;
import de.betterform.xml.config.Config;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.submission.Submission;
import java.net.URI;
import java.util.Map;
import org.w3c.dom.Node;

public class AbstractConnector
implements Connector {
    private String uri;
    private String defaultEncoding = "UTF-8";
    private InstanceSerializerMap instanceSerializerMap;
    private Map context;

    @Override
    public void setURI(String uri) {
        this.uri = uri;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    public void registerSerializer(String scheme, String method, String mediatype, InstanceSerializer serializer) throws XFormsException {
        if (this.instanceSerializerMap == null) {
            Config config = Config.getInstance();
            this.instanceSerializerMap = new InstanceSerializerMap(config.getInstanceSerializerMap());
        }
        this.instanceSerializerMap.registerSerializer(scheme, method, mediatype, serializer);
    }

    public InstanceSerializer getSerializer(String scheme, String method, String mediatype) throws XFormsException {
        if (this.instanceSerializerMap == null) {
            Config config = Config.getInstance();
            this.instanceSerializerMap = new InstanceSerializerMap(config.getInstanceSerializerMap());
        }
        return this.instanceSerializerMap.getSerializer(scheme, method, mediatype);
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    @Override
    public void setContext(Map context) {
        this.context = context;
    }

    @Override
    public Map getContext() {
        return this.context;
    }

    protected String getURIWithoutFragment() {
        return URIUtil.getURIWithoutFragment(this.uri);
    }

    protected final void serialize(Submission submission, Node instance, SerializerRequestWrapper wrapper) throws Exception {
        InstanceSerializer serializer;
        if (submission.getSerialization() != null && submission.getSerialization().equalsIgnoreCase("none")) {
            return;
        }
        String method = submission.getMethod();
        if (method == null) {
            throw new XFormsException("Submission method not defined at: " + DOMUtil.getCanonicalPath(submission.getElement()));
        }
        URI uri = new URI(this.getURI());
        String scheme = uri.getScheme();
        String mediatype = submission.getMediatype();
        if (mediatype == null) {
            mediatype = "application/xml";
        }
        if ((serializer = this.getSerializer(scheme, method, mediatype)) == null) {
            throw new XFormsException("No instance serializer defined for scheme '" + scheme + "', method '" + method + "' and mediatype '" + mediatype + "' at: " + DOMUtil.getCanonicalPath(submission.getElement()));
        }
        serializer.serialize(submission, instance, wrapper, this.getDefaultEncoding());
    }

    public boolean validateSchema(Submission submission, Node instance) throws XFormsException {
        Model model = submission.getModel();
        SchemaValidator validator = new SchemaValidator();
        return validator.validateSchema(model, instance);
    }
}

