/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector;

import de.betterform.connector.DefaultConnectorFactory;
import de.betterform.connector.SubmissionHandler;
import de.betterform.connector.URIResolver;
import de.betterform.xml.base.XMLBaseResolver;
import de.betterform.xml.config.Config;
import de.betterform.xml.config.XFormsConfigException;
import de.betterform.xml.xforms.Container;
import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.XFormsProcessorImpl;
import de.betterform.xml.xforms.action.AbstractBoundAction;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.exception.XFormsInternalSubmitException;
import de.betterform.xml.xforms.model.submission.Submission;
import de.betterform.xml.xpath.XPathUtil;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Element;

public abstract class ConnectorFactory {
    private static Log LOGGER = LogFactory.getLog(ConnectorFactory.class);
    private Map context = null;

    public abstract SubmissionHandler createSubmissionHandler(String var1, Element var2) throws XFormsException;

    public abstract URIResolver createURIResolver(String var1, Element var2) throws XFormsException;

    public void setContext(Map context) {
        this.context = context;
    }

    public Map getContext() {
        return this.context;
    }

    public static ConnectorFactory getFactory() throws XFormsConfigException {
        ConnectorFactory factory;
        String className = Config.getInstance().getConnectorFactory();
        if (className == null || className.equals("")) {
            factory = new DefaultConnectorFactory();
        } else {
            try {
                Class<?> clazz = Class.forName(className, true, ConnectorFactory.class.getClassLoader());
                factory = (ConnectorFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new XFormsConfigException(cnfe);
            }
            catch (ClassCastException cce) {
                throw new XFormsConfigException(cce);
            }
            catch (InstantiationException ie) {
                throw new XFormsConfigException(ie);
            }
            catch (IllegalAccessException iae) {
                throw new XFormsConfigException(iae);
            }
        }
        return factory;
    }

    public URI getAbsoluteURI(String uri, Element element) throws XFormsException {
        String uriString = this.evalAttributeValueTemplates(uri, element);
        try {
            String baseUri = XMLBaseResolver.resolveXMLBase(element, uriString);
            if (baseUri.equals(uriString) && !new URI(baseUri).isAbsolute()) {
                XFormsProcessorImpl processor = this.getProcessor(element);
                if (processor.getBaseURI() != null) {
                    return new URI(processor.getBaseURI()).resolve(uriString);
                }
                throw new XFormsException("no base uri present");
            }
            return new URI(baseUri);
        }
        catch (URISyntaxException e) {
            throw new XFormsException(e);
        }
    }

    public String evalAttributeValueTemplates(String uri, Element element) throws XFormsException {
        String toReplace = uri;
        String value = "";
        StringBuffer substitutedString = new StringBuffer();
        boolean hasTokens = true;
        while (hasTokens) {
            int start = toReplace.indexOf("{");
            int end = toReplace.indexOf(125);
            if (start == -1 || end == -1) {
                hasTokens = false;
                substitutedString.append(toReplace);
                continue;
            }
            substitutedString.append(toReplace.substring(0, start));
            String valueTemplate = toReplace.substring(start + 1, end);
            if (valueTemplate.startsWith("$")) {
                if (this.context.containsKey(valueTemplate = valueTemplate.substring(1))) {
                    value = this.context.get(valueTemplate).toString();
                }
            } else {
                value = this.evalXPath(element, valueTemplate);
            }
            if (value.equals("")) {
                LOGGER.warn((Object)("valueTemplate could not be evaluated. Replacing '" + valueTemplate + "' with empty string"));
            }
            substitutedString.append(value);
            toReplace = toReplace.substring(end + 1);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Uri: " + uri + " evaluated to: " + substitutedString));
        }
        return substitutedString.toString();
    }

    private String evalXPath(Element element, String valueTemplate) throws XFormsException {
        String xpath;
        XFormsElement xElement = (XFormsElement)element.getUserData("");
        if (XPathUtil.hasInstanceFunction(valueTemplate)) {
            xpath = valueTemplate;
        } else {
            String path;
            if (xElement instanceof AbstractBoundAction) {
                path = ((AbstractBoundAction)xElement).getLocationPath();
            } else if (xElement instanceof Submission) {
                path = ((Submission)xElement).getLocationPath();
            } else {
                LOGGER.warn((Object)"no AVT processing for this element implemented - returning default instance root as context path");
                path = "instance('default')";
            }
            xpath = this.evalJoinedXPath(path, valueTemplate);
        }
        return XPathCache.getInstance().evaluateAsString(xElement.getModel().getDefaultInstance().getRootContext(), xpath);
    }

    private String evalJoinedXPath(String path, String valueTemplate) {
        String[] steps = new String[]{path, valueTemplate};
        return XPathUtil.joinPathExpr(steps);
    }

    public String applyContextProperties(String uri) throws XFormsException {
        String toReplace = uri;
        StringBuffer substitutedString = new StringBuffer();
        boolean hasTokens = true;
        while (hasTokens) {
            String value;
            int start = toReplace.indexOf("{$");
            int end = toReplace.indexOf(125);
            if (start == -1 || end == -1) {
                hasTokens = false;
                substitutedString.append(toReplace);
                continue;
            }
            substitutedString.append(toReplace.substring(0, start));
            String key = toReplace.substring(start + 2, end);
            if (this.context.containsKey(key)) {
                value = this.context.get(key).toString();
            } else {
                value = "";
                LOGGER.warn((Object)("replaced non-existing key '" + key + "' with empty string"));
            }
            substitutedString.append(value);
            toReplace = toReplace.substring(end + 1);
        }
        return substitutedString.toString();
    }

    public InputStream getHTTPResourceAsStream(URI uri) throws XFormsException {
        try {
            HttpGet httpMethod = new HttpGet(uri.toString());
            BasicHttpParams httpParams = new BasicHttpParams();
            DefaultHttpClient client = this.getHttpClient((HttpParams)httpParams);
            HttpResponse response = client.execute((HttpUriRequest)httpMethod);
            if (response.getStatusLine().getStatusCode() >= 300 && response.getStatusLine().getStatusCode() != 302) {
                throw new XFormsInternalSubmitException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), EntityUtils.toString((HttpEntity)response.getEntity()), "resource-error");
            }
            return response.getEntity().getContent();
        }
        catch (IOException e) {
            throw new XFormsException(e);
        }
        catch (XFormsInternalSubmitException e) {
            throw new XFormsException(e);
        }
    }

    protected XFormsProcessorImpl getProcessor(Element e) {
        Object o = e.getOwnerDocument().getDocumentElement().getUserData("");
        if (o instanceof Container) {
            return ((Container)o).getProcessor();
        }
        return null;
    }

    public DefaultHttpClient getHttpClient(HttpParams httpParams) {
        return new DefaultHttpClient(httpParams);
    }
}

