/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector.context;

import de.betterform.connector.AbstractConnector;
import de.betterform.connector.URIResolver;
import de.betterform.xml.xforms.exception.XFormsException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.w3c.dom.Node;

public class ContextMapResolver
extends AbstractConnector
implements URIResolver {
    @Override
    public Object resolve() throws XFormsException {
        String uriString = this.getURI();
        String key = ContextMapResolver.getContextKeyFormURI(uriString);
        return ContextMapResolver.getNodeFromContext(key, this.getContext());
    }

    public static Object getNodeFromContext(String key, Map contextMap) throws XFormsException {
        if (contextMap.containsKey(key)) {
            Object o = contextMap.remove(key);
            if (!(o instanceof Node)) {
                throw new XFormsException("Object stored under key'" + key + "' must be a DOM Node");
            }
            return o;
        }
        throw new XFormsException("Cannot resolve context-param '" + key + "'");
    }

    public static String getContextKeyFormURI(String uriString) throws XFormsException {
        URI uri;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new XFormsException("invalid URI syntax: '" + uriString + "'", e);
        }
        return uri.getSchemeSpecificPart();
    }
}

