/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector.exec;

import de.betterform.connector.AbstractConnector;
import de.betterform.connector.SubmissionHandler;
import de.betterform.connector.exec.ProcessExecutor;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.submission.Submission;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Category;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExecSubmissionHandler
extends AbstractConnector
implements SubmissionHandler {
    private static final Category LOGGER = Category.getInstance(ExecSubmissionHandler.class);

    @Override
    public Map submit(Submission submission, Node node) throws XFormsException {
        if (!"instance".equalsIgnoreCase(submission.getReplace())) {
            return null;
        }
        try {
            URI baseURI = new URI(submission.getContainerObject().getProcessor().getBaseURI());
            URI actionURI = new URI(this.getURI());
            String schemeAction = actionURI.getSchemeSpecificPart();
            File program = new File(baseURI.resolve(schemeAction));
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("executing '" + program.getAbsolutePath() + "'"));
            }
            int code = new ProcessExecutor().execute(program.getParentFile(), program.getAbsolutePath() + this.getParameters(node), outputStream, errorStream);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("stdout '" + outputStream.toString() + "'"));
                LOGGER.debug((Object)("stderr '" + errorStream.toString() + "'"));
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            Document document = factory.newDocumentBuilder().newDocument();
            document.appendChild(document.createElementNS(null, "exec"));
            Element rootElement = document.getDocumentElement();
            Element element = document.createElement("command");
            DOMUtil.setElementValue(element, program.getName());
            rootElement.appendChild(element);
            element = document.createElement("working-dir");
            DOMUtil.setElementValue(element, program.getParentFile().toURI().getPath());
            rootElement.appendChild(element);
            element = document.createElement("exit-code");
            DOMUtil.setElementValue(element, String.valueOf(code));
            rootElement.appendChild(element);
            element = document.createElement("std-out");
            DOMUtil.setElementValue(element, outputStream.toString());
            rootElement.appendChild(element);
            element = document.createElement("std-err");
            DOMUtil.setElementValue(element, errorStream.toString());
            rootElement.appendChild(element);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DOMUtil.prettyPrintDOM((Node)document, stream);
            HashMap<String, ByteArrayInputStream> response = new HashMap<String, ByteArrayInputStream>();
            response.put("betterform.submission.response.stream", new ByteArrayInputStream(stream.toByteArray()));
            return response;
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
    }

    protected String getParameters(Node node) {
        Element rootNode = ((Document)node).getDocumentElement();
        Node argsNode = DOMUtil.getFirstChildByTagName(rootNode, "args");
        if (argsNode != null) {
            return " " + DOMUtil.getTextNodeAsString(argsNode);
        }
        return "";
    }
}

