/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector.exist;

import de.betterform.connector.exist.ExistClient;
import de.betterform.xml.xforms.exception.XFormsException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public abstract class ExistClientExecutable<T> {
    private Map<String, Object> context;
    private int lock;
    private URI uri;
    private XmldbURI xmldbUri;
    private ExistClient client;
    private Map<String, String> queryParameter;
    private BrokerPool pool;
    private DBBroker broker;

    public ExistClientExecutable() {
    }

    public ExistClientExecutable(Map<String, String> queryParameter) {
        this.setQueryParameter(queryParameter);
    }

    public T execute(Txn tx, BrokerPool pool, DBBroker broker, DocumentImpl xmlResource) throws Exception {
        return null;
    }

    protected String serialize(Sequence resultSequence) throws Exception {
        if (resultSequence == null || resultSequence.getItemCount() != 1) {
            throw new XFormsException("XML is not well formed");
        }
        Item item = resultSequence.itemAt(0);
        if (Type.subTypeOf((int)item.getType(), (int)-1)) {
            return this.getDBBroker().getSerializer().serialize((NodeValue)item);
        }
        if (Type.subTypeOf((int)item.getType(), (int)22)) {
            return item.getStringValue();
        }
        throw new XFormsException("The xquery did not return a valid XML node");
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    public String getUriString() {
        return this.uri.toString();
    }

    public URI getUri() throws URISyntaxException {
        return this.uri;
    }

    public XmldbURI getXmlDbUri() throws URISyntaxException {
        return this.xmldbUri;
    }

    public void setUriString(String uriString) throws URISyntaxException {
        this.uri = new URI(uriString);
        this.xmldbUri = XmldbURI.createInternal((String)this.uri.getRawPath());
    }

    public int getLock() {
        return this.lock;
    }

    public void setLock(int lock) {
        this.lock = lock;
    }

    public ExistClient getClient() {
        return this.client;
    }

    public void setClient(ExistClient client) {
        this.client = client;
    }

    public Map<String, String> getQueryParameter() {
        if (null == this.queryParameter) {
            this.queryParameter = new HashMap<String, String>();
        }
        return this.queryParameter;
    }

    public void setQueryParameter(Map<String, String> queryParameter) {
        this.queryParameter = queryParameter;
    }

    public void setBrokerPool(BrokerPool pool) {
        this.pool = pool;
    }

    public BrokerPool getPool() {
        return this.pool;
    }

    public void setDBBroker(DBBroker broker) {
        this.broker = broker;
    }

    public DBBroker getDBBroker() {
        return this.broker;
    }
}

