/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector.exist;

import de.betterform.connector.exist.ExistClientExecutable;
import de.betterform.connector.exist.ExistUtil;
import org.exist.collections.Collection;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.Txn;

public abstract class ExistResourceTypeCallback<T>
extends ExistClientExecutable<T> {
    @Override
    public T execute(Txn tx, BrokerPool pool, DBBroker broker, DocumentImpl xmlResrouce) throws Exception {
        Collection collection = broker.getCollection(this.getXmlDbUri());
        DocumentImpl xmlResource = broker.getResource(this.getXmlDbUri(), this.getLock());
        switch (ExistUtil.getExistResourceType(pool, broker, xmlResource, collection, this.getQueryParameter(), this.getUriString())) {
            case COLLECTION: {
                return this.onCollection(pool, broker, collection, tx);
            }
            case XML: {
                return this.onXMLResource(pool, broker, xmlResource, tx);
            }
            case XQUERY: {
                return this.onXQuery(pool, broker, xmlResource, tx);
            }
            case XQUERY_MODULE: {
                return this.onXQueryModule(pool, broker, xmlResource, tx);
            }
            case BINARY: {
                return this.onBinaryResource(pool, broker, xmlResource, tx);
            }
        }
        return this.onResourceNotFound(pool, broker, tx);
    }

    public T defaultOperation(BrokerPool pool, DBBroker broker, Txn tx) throws Exception {
        return null;
    }

    public T onResourceNotFound(BrokerPool pool, DBBroker broker, Txn tx) throws Exception {
        return this.defaultOperation(pool, broker, tx);
    }

    public T onCollection(BrokerPool pool, DBBroker broker, Collection collection, Txn tx) throws Exception {
        return this.defaultOperation(pool, broker, tx);
    }

    public T onBinaryResource(BrokerPool pool, DBBroker broker, DocumentImpl xmlResource, Txn tx) throws Exception {
        return this.defaultOperation(pool, broker, tx);
    }

    public T onXMLResource(BrokerPool pool, DBBroker broker, DocumentImpl xmlResource, Txn tx) throws Exception {
        return this.defaultOperation(pool, broker, tx);
    }

    public T onXQueryModule(BrokerPool pool, DBBroker broker, DocumentImpl xmlResource, Txn tx) throws Exception {
        return this.onBinaryResource(pool, broker, xmlResource, tx);
    }

    public T onXQuery(BrokerPool pool, DBBroker broker, DocumentImpl xmlResource, Txn tx) throws Exception {
        return this.onBinaryResource(pool, broker, xmlResource, tx);
    }
}

