/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector.exist;

import de.betterform.connector.AbstractConnector;
import de.betterform.connector.SubmissionHandler;
import de.betterform.connector.exist.ExistClient;
import de.betterform.connector.exist.ExistClientExecutable;
import de.betterform.connector.exist.ExistConnectorMethod;
import de.betterform.connector.exist.ExistResourceTypeCallback;
import de.betterform.connector.exist.ExistUtil;
import de.betterform.connector.serializer.SerializerRequestWrapper;
import de.betterform.connector.util.URIUtil;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.submission.Submission;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ExistSubmissionHandler
extends AbstractConnector
implements SubmissionHandler {
    private static Log LOGGER = LogFactory.getLog(ExistSubmissionHandler.class);
    private ExistClient existClient = new ExistClient();

    @Override
    public Map submit(Submission submission, Node instance) throws XFormsException {
        try {
            boolean hasPayload;
            this.setContext(submission.getContainerObject().getProcessor().getContext());
            ExistConnectorMethod method = ExistConnectorMethod.valueOf(submission.getMethod().toUpperCase());
            String mediatype = "application/xml";
            if (submission.getMediatype() != null) {
                mediatype = submission.getMediatype();
            }
            String encoding = submission.getEncoding();
            if (submission.getEncoding() == null) {
                encoding = this.getDefaultEncoding();
            }
            SerializerRequestWrapper wrapper = new SerializerRequestWrapper(new ByteArrayOutputStream());
            this.serialize(submission, instance, wrapper);
            ByteArrayOutputStream stream = (ByteArrayOutputStream)wrapper.getBodyStream();
            boolean bl = hasPayload = !"".equals(stream.toString());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("submitting with method='" + (Object)((Object)method) + "', has payload='" + hasPayload + "'"));
            }
            switch (method) {
                case GET: {
                    return this.doGet(this.getURI(), mediatype, encoding);
                }
                case EXECUTE: {
                    return this.doExecute(this.getURI(), mediatype, encoding, stream);
                }
                case POST: {
                    return this.doPut(this.getURI(), mediatype, encoding, stream);
                }
                case PUT: {
                    return this.doPut(this.getURI(), mediatype, encoding, stream);
                }
                case DELETE: {
                    return this.doDelete(this.getURI(), mediatype, encoding);
                }
            }
            throw new XFormsException("submission method '" + (Object)((Object)method) + "' not supported");
        }
        catch (Exception e) {
            HashMap<String, String> failure = new HashMap<String, String>();
            failure.put("response-reason-phrase", e.getMessage());
            failure.put("error-type", "target-error");
            return failure;
        }
    }

    private Map<String, Object> doExecute(String uri, String mediatype, String encoding, ByteArrayOutputStream stream) throws Exception {
        String resultString = ExistUtil.executeXQuery(uri, this.getContext(), mediatype, encoding, stream);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("betterform.submission.response.document", DOMUtil.parseString(resultString, true, true));
        return result;
    }

    private Map<String, Object> doGet(String uri, String mediatype, String encoding) throws Exception {
        String response = null;
        response = URIUtil.hasFileExtension(uri, "xql", "xqm") ? ExistUtil.executeXQuery(uri, this.getContext(), mediatype, encoding, null) : ExistUtil.getExistResource(uri, this.getContext(), mediatype, encoding, null);
        Document result = DOMUtil.parseString(response, true, true);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("betterform.submission.response.document", result);
        return resultMap;
    }

    private Map<String, Object> doDelete(String uri, String mediatype, String encoding) throws Exception {
        Boolean result = this.existClient.execute(uri, 1, this.getContext(), new ExistResourceTypeCallback<Boolean>(){

            @Override
            public Boolean onCollection(BrokerPool pool, DBBroker broker, Collection collection, Txn tx) throws Exception {
                broker.removeCollection(tx, collection);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("collection removed: '" + collection.getURI() + "'"));
                }
                return Boolean.TRUE;
            }

            @Override
            public Boolean onBinaryResource(BrokerPool pool, DBBroker broker, DocumentImpl xmlResource, Txn tx) throws Exception {
                xmlResource.getCollection().removeBinaryResource(tx, broker, this.getXmlDbUri().lastSegment());
                return Boolean.TRUE;
            }

            @Override
            public Boolean onXMLResource(BrokerPool pool, DBBroker broker, DocumentImpl xmlResource, Txn tx) throws Exception {
                xmlResource.getCollection().removeXMLResource(tx, broker, this.getXmlDbUri().lastSegment());
                return Boolean.TRUE;
            }
        });
        Document doc = DOMUtil.parseString("<operation type='delete' uri='" + uri + "' successful='" + result + "'/>", true, false);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("betterform.submission.response.document", doc);
        return response;
    }

    private Map<String, Object> doPut(String uri, String mediatype, final String encoding, final ByteArrayOutputStream stream) throws Exception {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (ExistUtil.isExistCollection(uri, this.getContext())) {
            uri = uri + "/" + System.currentTimeMillis() + ".xml";
            resultMap.put("resource-uri", uri);
        }
        this.existClient.execute(uri, 1, this.getContext(), new ExistClientExecutable<DocumentImpl>(){

            @Override
            public DocumentImpl execute(Txn tx, BrokerPool pool, DBBroker broker, DocumentImpl xmlResource) throws Exception {
                String file = URIUtil.getLastSegmentFromPath(this.getUri());
                String path = URIUtil.getPathWithoutLastSegment(this.getUri());
                DocumentImpl resource = broker.getResource(this.getXmlDbUri(), 1);
                Collection collection = null;
                if (null == resource) {
                    XmldbURI pathUri = XmldbURI.createInternal((String)path);
                    collection = broker.getCollection(pathUri);
                } else {
                    collection = resource.getCollection();
                }
                byte[] data = stream.toByteArray();
                String contents = new String(data, Charset.forName(encoding));
                IndexInfo info = collection.validateXMLResource(tx, broker, XmldbURI.createInternal((String)file), contents);
                collection.store(tx, broker, info, contents, false);
                return info.getDocument();
            }
        });
        return this.doGet(uri, mediatype, encoding);
    }
}

