/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector.file;

import de.betterform.connector.AbstractConnector;
import de.betterform.connector.URIResolver;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.exception.XFormsException;
import java.io.File;
import java.net.URI;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileURIResolver
extends AbstractConnector
implements URIResolver {
    private static Log LOGGER = LogFactory.getLog(FileURIResolver.class);

    @Override
    public Object resolve() throws XFormsException {
        try {
            File file;
            URI uri = new URI(this.getURI());
            String fileName = uri.getSchemeSpecificPart();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("loading file '" + fileName + "'"));
            }
            if ((file = new File(fileName)).isDirectory()) {
                return FileURIResolver.buildDirectoryListing(file);
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            Document document = factory.newDocumentBuilder().parse(file);
            if (uri.getFragment() != null) {
                return document.getElementById(uri.getFragment());
            }
            return document;
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
    }

    public static Document buildDirectoryListing(File directory) {
        Document dirList = DOMUtil.newDocument(false, false);
        Element root = dirList.createElement("dir");
        root.setAttribute("path", directory.toURI().toString());
        root.setAttribute("parentDir", directory.getParentFile().toURI().toString());
        File[] fileList = directory.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            File file = fileList[i];
            Element element = file.isDirectory() ? dirList.createElement("dir") : dirList.createElement("file");
            element.setAttribute("name", file.getName());
            element.setAttribute("path", file.toURI().toString());
            root.appendChild(element);
        }
        dirList.appendChild(root);
        return dirList;
    }
}

