/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector.http;

import de.betterform.connector.AbstractConnector;
import de.betterform.connector.ConnectorFactory;
import de.betterform.connector.http.ssl.KeyStoreSSLContext;
import de.betterform.xml.config.Config;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.exception.XFormsInternalSubmitException;
import de.betterform.xml.xforms.model.submission.RequestHeader;
import de.betterform.xml.xforms.model.submission.RequestHeaders;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.cookie.BrowserCompatSpec;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.util.EntityUtils;

public class AbstractHTTPConnector
extends AbstractConnector {
    private static Log LOGGER = LogFactory.getLog(AbstractHTTPConnector.class);
    public static final String REQUEST_COOKIE = "request-cookie";
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    protected int statusCode = 0;
    protected String reasonPhrase = "";
    public static final String SSL_CUSTOM_SCHEME = "ssl_custom_scheme";
    public static final String HTTPCLIENT_SSL_CONTEXT = "httpclient.ssl.context";
    public static final String HTTPCLIENT_SSL_CONTEXT_CUSTOMPORT = "httpclient.ssl.context.customPort";
    public static final String HTTPCLIENT_SSL_KEYSTORE_PATH = "httpclient.ssl.keystore.path";
    public static final String HTTPCLIENT_SSL_KEYSTORE_PASSWD = "httpclient.ssl.keystore.passwd";
    private InputStream responseBody = null;
    private Map responseHeader = null;
    public static final String HTTP_REQUEST_HEADERS = "http-headers";
    private Map submissionMap = null;

    protected InputStream getResponseBody() {
        return this.responseBody;
    }

    protected Map getResponseHeader() {
        return this.responseHeader;
    }

    protected void setSubmissionMap(Map map) {
        this.submissionMap = map;
    }

    protected void get(String uri) throws XFormsException {
        HttpGet httpRequestBase = new HttpGet(uri);
        try {
            this.execute((HttpRequestBase)httpRequestBase);
        }
        catch (XFormsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
    }

    protected void post(String uri, String body, String encoding) throws XFormsException {
        this.post(uri, body, "application/xml", encoding);
    }

    protected void post(String uri, String body, String type, String encoding) throws XFormsException {
        HttpPost httpMethod = new HttpPost(uri);
        try {
            this.configureRequest((HttpEntityEnclosingRequestBase)httpMethod, body, type, encoding);
            this.execute((HttpRequestBase)httpMethod);
        }
        catch (XFormsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
    }

    protected void put(String uri, String body, String encoding) throws XFormsException {
        this.put(uri, body, "application/xml", encoding);
    }

    protected void put(String uri, String body, String type, String encoding) throws XFormsException {
        HttpPut httpMethod = new HttpPut(uri);
        try {
            this.configureRequest((HttpEntityEnclosingRequestBase)httpMethod, body, type, encoding);
            this.execute((HttpRequestBase)httpMethod);
        }
        catch (XFormsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
    }

    protected void delete(String uri) throws XFormsException {
        HttpDelete httpMethod = new HttpDelete(uri);
        try {
            this.execute((HttpRequestBase)httpMethod);
        }
        catch (XFormsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
    }

    protected void execute(HttpRequestBase httpRequestBase) throws Exception {
        BasicHttpParams httpParams = new BasicHttpParams();
        DefaultHttpClient client = ConnectorFactory.getFactory().getHttpClient((HttpParams)httpParams);
        if (!this.getContext().containsKey(SSL_CUSTOM_SCHEME)) {
            LOGGER.debug((Object)"SSL_CUSTOM_SCHEME");
            LOGGER.debug((Object)("SSL_CUSTOM_SCHEME: Factory: " + Config.getInstance().getProperty(HTTPCLIENT_SSL_CONTEXT)));
            String contextPath = Config.getInstance().getProperty(HTTPCLIENT_SSL_CONTEXT);
            if (contextPath != null) {
                this.initSSLScheme(contextPath);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"context params>>>");
            Map map = this.getContext();
            Iterator keys = map.keySet().iterator();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                Object value = map.get(key);
                if (value == null) continue;
                LOGGER.debug((Object)(key + "=" + value.toString()));
            }
            LOGGER.debug((Object)"<<<end params");
        }
        String username = null;
        String password = null;
        String realm = null;
        httpRequestBase.addHeader("betterform-internal", "true");
        if (this.getContext().containsKey(HTTP_REQUEST_HEADERS)) {
            RequestHeaders httpRequestHeaders = (RequestHeaders)this.getContext().get(HTTP_REQUEST_HEADERS);
            HashMap<String, String> headersToAdd = new HashMap<String, String>();
            for (RequestHeader header : httpRequestHeaders.getAllHeaders()) {
                String headername = header.getName();
                String headervalue = header.getValue();
                if (headername.equals("username")) {
                    username = headervalue;
                    continue;
                }
                if (headername.equals("password")) {
                    password = headervalue;
                    continue;
                }
                if (headername.equals("realm")) {
                    realm = headervalue;
                    continue;
                }
                if (headersToAdd.containsKey(headername)) {
                    String formerValue = (String)headersToAdd.get(headername);
                    headersToAdd.put(headername, formerValue + "," + headervalue);
                    continue;
                }
                if (headername.equals("accept-encoding")) {
                    LOGGER.debug((Object)("do not add accept-encoding:" + headervalue + " for request"));
                    continue;
                }
                headersToAdd.put(headername, headervalue);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("setting header: " + headername + " value: " + headervalue));
            }
            for (String key : headersToAdd.keySet()) {
                httpRequestBase.setHeader(key, (String)headersToAdd.get(key));
            }
        }
        if (httpRequestBase.containsHeader("Content-Length")) {
            httpRequestBase.removeHeaders("Content-Length");
        }
        if (username != null && password != null) {
            URI targetURI = null;
            targetURI = httpRequestBase.getURI();
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(username, password);
            if (realm == null) {
                realm = AuthScope.ANY_REALM;
            }
            client.getCredentialsProvider().setCredentials(new AuthScope(targetURI.getHost(), targetURI.getPort(), realm), (Credentials)defaultcreds);
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(new HttpHost(targetURI.getHost()), (AuthScheme)basicAuth);
            BasicHttpContext localContext = new BasicHttpContext();
            localContext.setAttribute("http.auth.auth-cache", (Object)authCache);
        }
        if (this.getContext().containsKey(REQUEST_COOKIE)) {
            HttpParams state = client.getParams();
            state.setParameter("http.protocol.cookie-policy", (Object)"compatibility");
            if (this.getContext().get(REQUEST_COOKIE) instanceof Cookie[]) {
                Cookie[] cookiesIn = (Cookie[])this.getContext().get(REQUEST_COOKIE);
                if (cookiesIn[0] != null) {
                    for (int i = 0; i < cookiesIn.length; ++i) {
                        Cookie cookie = cookiesIn[i];
                        client.getCookieStore().addCookie(cookie);
                    }
                    List cookies = client.getCookieStore().getCookies();
                    List cookieHeaders = new BrowserCompatSpec().formatCookies(cookies);
                    Header[] headers = cookieHeaders.toArray(new Header[0]);
                    for (int i = 0; i < headers.length; ++i) {
                        httpRequestBase.addHeader(headers[i]);
                    }
                    client.setParams(state);
                }
            } else {
                throw new MalformedCookieException("Cookies must be passed as org.apache.commons.httpclient.Cookie objects.");
            }
        }
        if (this.getContext().containsKey(SSL_CUSTOM_SCHEME)) {
            LOGGER.debug((Object)"Using customSSL-Protocol-Handler");
            Iterator schemes = ((Vector)this.getContext().get(SSL_CUSTOM_SCHEME)).iterator();
            while (schemes.hasNext()) {
                client.getConnectionManager().getSchemeRegistry().register((Scheme)schemes.next());
            }
        }
        if (httpRequestBase.getURI().isAbsolute()) {
            httpRequestBase.setHeader("host", httpRequestBase.getURI().getHost());
        }
        HttpResponse httpResponse = client.execute((HttpUriRequest)httpRequestBase);
        this.statusCode = httpResponse.getStatusLine().getStatusCode();
        this.reasonPhrase = httpResponse.getStatusLine().getReasonPhrase();
        try {
            if (this.statusCode >= 300 && this.statusCode != 302) {
                throw new XFormsInternalSubmitException(this.statusCode, this.reasonPhrase, EntityUtils.toString((HttpEntity)httpResponse.getEntity()), "resource-error");
            }
            this.handleHttpMethod(httpResponse);
        }
        catch (Exception e) {
            LOGGER.trace((Object)"AbstractHTTPConnector Exception: ", (Throwable)e);
            try {
                throw new XFormsInternalSubmitException(httpResponse.getStatusLine().getStatusCode(), httpResponse.getStatusLine().getReasonPhrase(), EntityUtils.toString((HttpEntity)httpResponse.getEntity()), "resource-error");
            }
            catch (IOException e1) {
                throw new XFormsInternalSubmitException(httpResponse.getStatusLine().getStatusCode(), httpResponse.getStatusLine().getReasonPhrase(), "resource-error");
            }
        }
    }

    protected void handleHttpMethod(HttpResponse httpResponse) throws Exception {
        Header[] responseHeaders = httpResponse.getAllHeaders();
        this.responseHeader = new HashMap();
        for (int index = 0; index < responseHeaders.length; ++index) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("response header :: " + responseHeaders[index].getName() + " : value = " + responseHeaders[index].getValue()));
            }
            this.responseHeader.put(responseHeaders[index].getName(), responseHeaders[index].getValue());
        }
        if (httpResponse.getEntity() != null) {
            this.responseBody = this.responseHeader.containsKey("Content-Encoding") && ((String)this.responseHeader.get("Content-Encoding")).equalsIgnoreCase("gzip") ? new GZIPInputStream(httpResponse.getEntity().getContent()) : httpResponse.getEntity().getContent();
        }
    }

    private void configureRequest(HttpEntityEnclosingRequestBase httpMethod, String body, String type, String encoding) throws UnsupportedEncodingException {
        StringEntity entity = new StringEntity(body, type, encoding);
        httpMethod.setEntity((HttpEntity)entity);
    }

    private void initSSLScheme(String contextPath) throws Exception {
        LOGGER.debug((Object)"creating sslScheme ...");
        LOGGER.debug((Object)("KeyStoreSSLContext: " + contextPath));
        Class<?> contextClass = Class.forName(contextPath);
        Object context = contextClass.newInstance();
        Vector<Scheme> schemes = new Vector<Scheme>();
        if (context instanceof KeyStoreSSLContext) {
            int httpSSLPort = 443;
            int tomcatSSLPort = 8443;
            SSLSocketFactory socketFactory = new SSLSocketFactory(((KeyStoreSSLContext)context).getSSLContext());
            if (Config.getInstance().getProperty(HTTPCLIENT_SSL_CONTEXT_CUSTOMPORT) != null) {
                try {
                    int customPort = Integer.parseInt(Config.getInstance().getProperty(HTTPCLIENT_SSL_CONTEXT_CUSTOMPORT));
                    LOGGER.trace((Object)("CustomPort: " + customPort));
                    Scheme sslScheme = new Scheme("https", customPort, (SchemeSocketFactory)socketFactory);
                    schemes.add(sslScheme);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warn((Object)"httpclient.ssl.context.customPort is not parsable as a number. Check your settings in betterform-config.xml!", (Throwable)nfe);
                }
            }
            Scheme sslScheme1 = new Scheme("https", httpSSLPort, (SchemeSocketFactory)socketFactory);
            schemes.add(sslScheme1);
            Scheme sslScheme2 = new Scheme("https", tomcatSSLPort, (SchemeSocketFactory)socketFactory);
            schemes.add(sslScheme2);
            this.getContext().put(SSL_CUSTOM_SCHEME, schemes);
        }
    }
}

