/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector.http;

import de.betterform.connector.ConnectorFactory;
import de.betterform.connector.http.HTTPSubmissionHandler;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.submission.Submission;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.w3c.dom.Node;

public class RedirectingHTTPSubmissionHandler
extends HTTPSubmissionHandler {
    private static Log LOGGER = LogFactory.getLog(RedirectingHTTPSubmissionHandler.class);
    private Submission mySubmission = null;

    @Override
    public Map submit(Submission submission, Node instance) throws XFormsException {
        this.mySubmission = submission;
        return super.submit(submission, instance);
    }

    @Override
    protected void execute(HttpRequestBase httpMethod) throws Exception {
        int idx;
        LOGGER.info((Object)"RedirectingHTTPSubmissionDriver.execute");
        BasicHttpParams httpParams = new BasicHttpParams();
        DefaultHttpClient client = ConnectorFactory.getFactory().getHttpClient((HttpParams)httpParams);
        HttpResponse response = client.execute((HttpUriRequest)httpMethod);
        if (response.getStatusLine().getStatusCode() >= 400) {
            throw new XFormsException("HTTP status " + response.getStatusLine().getStatusCode() + ": " + response.getStatusLine().getReasonPhrase());
        }
        String locationURL = null;
        if (response.getStatusLine().getStatusCode() == 201) {
            Header locationURLHdr = response.getFirstHeader("Location");
            if (null == locationURLHdr) {
                locationURLHdr = response.getFirstHeader("location");
            }
            if (null == locationURLHdr) {
                locationURLHdr = response.getFirstHeader("Content-Location");
            }
            if (null == locationURLHdr) {
                locationURLHdr = response.getFirstHeader("content-location");
            }
            if (null != locationURLHdr) {
                locationURL = locationURLHdr.getValue();
            }
        } else if (response.getStatusLine().getStatusCode() == 204 && (idx = (locationURL = httpMethod.getURI().toString()).lastIndexOf(47)) > -1) {
            locationURL = locationURL.substring(0, idx + 1);
        }
        if (null != locationURL) {
            LOGGER.info((Object)("Redirecting to location: " + locationURL));
            this.mySubmission.redirect(locationURL);
        }
        this.handleHttpMethod(response);
    }
}

