/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector.http.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BetterFORMKeyStoreManager
implements X509KeyManager {
    private static Log LOGGER = LogFactory.getLog(BetterFORMKeyStoreManager.class);
    private Vector<X509KeyManager> customX509KeyManagers;
    private X509KeyManager javaDefaultKeyManager;

    public BetterFORMKeyStoreManager() throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        this.initBetterFORMKeyStoreManager();
    }

    private void initBetterFORMKeyStoreManager() throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        this.customX509KeyManagers = new Vector();
        this.javaDefaultKeyManager = this.getJavaDefaultKeyManager();
    }

    public void addCustomX509KeyManager(URL url, String password) throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException, UnrecoverableKeyException {
        X509KeyManager customX509KeyManager = this.getCustomX509KeyManager(url, password);
        if (customX509KeyManager != null) {
            this.customX509KeyManagers.add(customX509KeyManager);
        } else {
            LOGGER.warn((Object)("BetterFORMKeyStoreManager.addCustomX509KeyManager: Keystore: " + url.getFile() + " not usable!"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509KeyManager getCustomX509KeyManager(URL url, String password) throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException, UnrecoverableKeyException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        if (url == null) {
            throw new IllegalArgumentException("BetterFORMKeyStoreManager: Keystore url may not be null");
        }
        LOGGER.debug((Object)"BetterFORMKeyStoreManager: initializing custom key store");
        KeyStore customKeystore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream is = null;){
            is = url.openStream();
            customKeystore.load(is, password != null ? password.toCharArray() : null);
        }
        if (LOGGER.isTraceEnabled()) {
            Enumeration<String> aliases = customKeystore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                LOGGER.trace((Object)("Trusted certificate '" + alias + "':"));
                Certificate trustedcert = customKeystore.getCertificate(alias);
                if (trustedcert == null || !(trustedcert instanceof X509Certificate)) continue;
                X509Certificate cert = (X509Certificate)trustedcert;
                LOGGER.trace((Object)("  Subject DN: " + cert.getSubjectDN()));
                LOGGER.trace((Object)("  Signature Algorithm: " + cert.getSigAlgName()));
                LOGGER.trace((Object)("  Valid from: " + cert.getNotBefore()));
                LOGGER.trace((Object)("  Valid until: " + cert.getNotAfter()));
                LOGGER.trace((Object)("  Issuer: " + cert.getIssuerDN()));
            }
        }
        keyManagerFactory.init(customKeystore, password.toCharArray());
        KeyManager[] customX509KeyManagers = keyManagerFactory.getKeyManagers();
        if (customX509KeyManagers != null && customX509KeyManagers.length > 0) {
            for (int i = 0; i < customX509KeyManagers.length; ++i) {
                if (!(customX509KeyManagers[i] instanceof X509KeyManager)) continue;
                return (X509KeyManager)customX509KeyManagers[i];
            }
        }
        return null;
    }

    private X509KeyManager getJavaDefaultKeyManager() throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(null, null);
        KeyManager[] x509KeyManagers = keyManagerFactory.getKeyManagers();
        if (x509KeyManagers != null && x509KeyManagers.length > 0) {
            for (int i = 0; i < x509KeyManagers.length; ++i) {
                if (!(x509KeyManagers[i] instanceof X509KeyManager)) continue;
                return (X509KeyManager)x509KeyManagers[i];
            }
        }
        LOGGER.warn((Object)"BetterFORMKeyStoreManager: No key managers available for default algorithm.");
        return null;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] principals, Socket socket) {
        for (X509KeyManager x509KeyManager : this.customX509KeyManagers) {
            if (x509KeyManager.chooseClientAlias(keyType, principals, socket) == null) continue;
            LOGGER.trace((Object)("BetterFORMKeyStoreManager.chooseClientAlias: Found client alias in custom keystore: " + x509KeyManager.toString()));
            return x509KeyManager.chooseClientAlias(keyType, principals, socket);
        }
        return this.javaDefaultKeyManager.chooseClientAlias(keyType, principals, socket);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] principals, Socket socket) {
        for (X509KeyManager x509KeyManager : this.customX509KeyManagers) {
            if (x509KeyManager.chooseServerAlias(keyType, principals, socket) == null) continue;
            LOGGER.trace((Object)("BetterFORMKeyStoreManager.chooseServerAlias: Found server alias in custom keystore: " + x509KeyManager.toString()));
            return x509KeyManager.chooseServerAlias(keyType, principals, socket);
        }
        return this.javaDefaultKeyManager.chooseServerAlias(keyType, principals, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        for (X509KeyManager x509KeyManager : this.customX509KeyManagers) {
            X509Certificate[] certificateChain = x509KeyManager.getCertificateChain(alias);
            if (certificateChain == null || certificateChain.length <= 0) continue;
            LOGGER.trace((Object)("BetterFORMKeyStoreManager.getCertificateChain: Certificate chain found for " + alias + " in custom keystore: " + x509KeyManager.toString()));
            return x509KeyManager.getCertificateChain(alias);
        }
        return this.javaDefaultKeyManager.getCertificateChain(alias);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] principals) {
        String[] customClientAliases = null;
        for (X509KeyManager x509KeyManager : this.customX509KeyManagers) {
            customClientAliases = (String[])ArrayUtils.addAll(customClientAliases, (Object[])x509KeyManager.getClientAliases(keyType, principals));
        }
        return (String[])ArrayUtils.addAll(customClientAliases, (Object[])this.javaDefaultKeyManager.getClientAliases(keyType, principals));
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        for (X509KeyManager x509KeyManager : this.customX509KeyManagers) {
            if (x509KeyManager.getPrivateKey(alias) == null) continue;
            LOGGER.trace((Object)("BetterFORMKeyStoreManager.getPrivateKey: Private key found for " + alias + " in custom keystore: " + x509KeyManager.toString()));
            return x509KeyManager.getPrivateKey(alias);
        }
        return this.javaDefaultKeyManager.getPrivateKey(alias);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] principals) {
        String[] customClientAliases = null;
        for (X509KeyManager x509KeyManager : this.customX509KeyManagers) {
            customClientAliases = (String[])ArrayUtils.addAll(customClientAliases, (Object[])x509KeyManager.getServerAliases(keyType, principals));
        }
        return (String[])ArrayUtils.addAll(customClientAliases, (Object[])this.javaDefaultKeyManager.getServerAliases(keyType, principals));
    }
}

