/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector.serializer;

import de.betterform.connector.InstanceSerializer;
import de.betterform.connector.serializer.SerializerRequestWrapper;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.ModelItem;
import de.betterform.xml.xforms.model.submission.Submission;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FormDataSerializer
implements InstanceSerializer {
    @Override
    public void serialize(Submission submission, Node instance, SerializerRequestWrapper wrapper, String defaultEncoding) throws Exception {
        if (instance == null) {
            return;
        }
        switch (instance.getNodeType()) {
            case 1: 
            case 3: {
                break;
            }
            case 9: {
                instance = ((Document)instance).getDocumentElement();
                break;
            }
            default: {
                return;
            }
        }
        String encoding = defaultEncoding;
        if (submission.getEncoding() != null) {
            encoding = submission.getEncoding();
        }
        Random rnd = new Random(System.currentTimeMillis());
        String boundary = DigestUtils.md5Hex((String)(this.getClass().getName() + rnd.nextLong()));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)bos, encoding)));
        if (instance.getNodeType() == 1) {
            this.serializeElement(writer, (Element)instance, boundary, encoding);
        } else {
            writer.print(instance.getTextContent());
        }
        writer.print("\r\n--" + boundary + "--");
        writer.flush();
        bos.writeTo(wrapper.getBodyStream());
        wrapper.addHeader("internal-boundary-mark", boundary);
    }

    protected void serializeElement(PrintWriter writer, Element element, String boundary, String charset) throws Exception {
        String nodeValue = null;
        boolean isCDATASection = false;
        boolean includeTextNode = true;
        NodeList list = element.getChildNodes();
        block4: for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            switch (n.getNodeType()) {
                case 3: {
                    if (!includeTextNode) continue block4;
                    if (nodeValue != null) {
                        includeTextNode = false;
                        continue block4;
                    }
                    nodeValue = n.getNodeValue();
                    continue block4;
                }
                case 1: {
                    includeTextNode = false;
                    this.serializeElement(writer, (Element)n, boundary, charset);
                    continue block4;
                }
            }
        }
        if (nodeValue != null && includeTextNode) {
            Object object = element.getUserData("");
            if (object != null && !(object instanceof ModelItem)) {
                throw new XFormsException("Unknown instance data format.");
            }
            ModelItem item = (ModelItem)object;
            writer.print("\r\n--" + boundary);
            String name = element.getLocalName();
            if (name == null) {
                name = element.getNodeName();
            }
            if (item != null && item.getMediatype() != null) {
                writer.print("\r\nContent-Disposition: form-data; name=\"" + name + "\";");
                if (item.getFilename() != null) {
                    File file = new File(item.getFilename());
                    writer.print(" filename=\"" + file.getName() + "\";");
                }
                writer.print("\r\nContent-Type: " + item.getMediatype());
            } else {
                writer.print("\r\nContent-Disposition: form-data; name=\"" + name + "\";");
                writer.print("\r\nContent-Type: text/plain; charset=\"" + charset + "\";");
            }
            String encoding = "8bit";
            if (item != null && "base64Binary".equalsIgnoreCase(item.getDeclarationView().getDatatype())) {
                encoding = "base64";
            } else if (item != null && "hexBinary".equalsIgnoreCase(item.getDeclarationView().getDatatype())) {
                nodeValue = new String(Base64.encodeBase64((byte[])Hex.decodeHex((char[])nodeValue.toCharArray()), (boolean)true));
                encoding = "base64";
            }
            writer.print("\r\nContent-Transfer-Encoding: " + encoding);
            writer.print("\r\n\r\n" + nodeValue);
        }
        writer.flush();
    }
}

