/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector.xmlrpc;

import de.betterform.connector.xmlrpc.DocTransformerException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class DocTransformer {
    private Document doc = null;
    boolean namespaceAware = true;
    boolean validating = false;

    public DocTransformer() {
    }

    public DocTransformer(Document doc) {
        this.setSource(doc);
    }

    public DocTransformer(byte[] bytes) throws DocTransformerException {
        this.setSource(bytes);
    }

    public DocTransformer(String string) throws DocTransformerException {
        this.setSource(string);
    }

    public DocTransformer(File file) throws DocTransformerException {
        this.setSource(file);
    }

    public void setNamespaceAware(boolean in) {
        this.namespaceAware = in;
    }

    public void setValidating(boolean in) {
        this.validating = in;
    }

    public void setSource(byte[] bytes) throws DocTransformerException {
        try {
            DocumentBuilder builder = this.getDocumentBuilder();
            this.doc = builder.parse(new ByteArrayInputStream(bytes));
        }
        catch (DocTransformerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DocTransformerException(e);
        }
    }

    public void setSource(String string) throws DocTransformerException {
        try {
            DocumentBuilder builder = this.getDocumentBuilder();
            this.doc = builder.parse(new ByteArrayInputStream(string.getBytes()));
        }
        catch (DocTransformerException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocTransformerException(e.getMessage(), e);
        }
    }

    public void setSource(File file) throws DocTransformerException {
        try {
            DocumentBuilder builder = this.getDocumentBuilder();
            this.doc = builder.parse(file);
        }
        catch (DocTransformerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DocTransformerException(e);
        }
    }

    public void setSource(Document doc) {
        this.doc = doc;
    }

    public Document newDoc() throws DocTransformerException {
        try {
            DocumentBuilder builder = this.getDocumentBuilder();
            return builder.newDocument();
        }
        catch (DocTransformerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DocTransformerException(e);
        }
    }

    public Document getDoc() throws DocTransformerException {
        if (this.doc == null) {
            try {
                DocumentBuilder builder = this.getDocumentBuilder();
                this.doc = builder.newDocument();
            }
            catch (DocTransformerException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DocTransformerException(e);
            }
        }
        return this.doc;
    }

    public byte[] getByteArray() throws DocTransformerException {
        try {
            Transformer trans = DocTransformer.getTransformer(null);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            trans.transform(new DOMSource(this.doc), new StreamResult(bs));
            return bs.toByteArray();
        }
        catch (DocTransformerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DocTransformerException(e);
        }
    }

    public String getString() throws DocTransformerException {
        try {
            Transformer trans = DocTransformer.getTransformer(null);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            trans.transform(new DOMSource(this.doc), new StreamResult(bs));
            return bs.toString();
        }
        catch (DocTransformerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DocTransformerException(e);
        }
    }

    public Hashtable getHash() throws DocTransformerException {
        return this.getHash(new Hashtable());
    }

    public Hashtable getHash(Hashtable h) throws DocTransformerException {
        Hashtable<String, Object> result = new Hashtable<String, Object>(h);
        if (this.doc == null) {
            result.put("status", "error");
            result.put("error", "Document is null returning hash");
            return result;
        }
        result.put("status", "ok");
        result.put("doc", this.getByteArray());
        return result;
    }

    private DocumentBuilder getDocumentBuilder() throws DocTransformerException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(this.namespaceAware);
            factory.setValidating(this.validating);
            return factory.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new DocTransformerException("Cannot get DocumentBuilder: " + e.getMessage(), e);
        }
    }

    private static Transformer getTransformer(Document doc) throws Exception {
        TransformerFactory transFactory = TransformerFactory.newInstance();
        if (doc == null) {
            return transFactory.newTransformer();
        }
        return transFactory.newTransformer(new DOMSource(doc));
    }
}

