/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.config;

import de.betterform.connector.InstanceSerializer;
import de.betterform.connector.InstanceSerializerMap;
import de.betterform.xml.config.Config;
import de.betterform.xml.config.XFormsConfigException;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.saxon.dom.DOMNodeWrapper;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sxpath.IndependentContext;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultConfig
extends Config {
    public DefaultConfig(InputStream stream) throws XFormsConfigException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            Document document = factory.newDocumentBuilder().parse(stream);
            DOMNodeWrapper context = this.getDocumentElementContext(document);
            this.properties = this.load((NodeInfo)context, "properties/property", "name", "value");
            this.uriResolvers = this.load((NodeInfo)context, "connectors/uri-resolver", "scheme", "class");
            this.submissionHandlers = this.load((NodeInfo)context, "connectors/submission-handler", "scheme", "class");
            this.errorMessages = this.load((NodeInfo)context, "error-messages/message", "id", "value");
            this.customElements = this.loadCustomElements((NodeInfo)context, "custom-elements/element");
            this.connectorFactory = this.load((NodeInfo)context, "connectors", "factoryClass");
            this.instanceSerializerMap = this.loadSerializer((NodeInfo)context, "register-serializer/instance-serializer", "scheme", "method", "mediatype", "class");
        }
        catch (Exception e) {
            throw new XFormsConfigException(e);
        }
    }

    private DOMNodeWrapper getDocumentElementContext(Document document) {
        return new DocumentWrapper((Node)document, "configuration.xml", new IndependentContext().getConfiguration()).wrap((Node)document.getDocumentElement());
    }

    private HashMap load(NodeInfo configContext, String sectionPath, String nameAttribute, String valueAttribute) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        List nodeset = XPathCache.getInstance().evaluate(configContext, sectionPath, Collections.EMPTY_MAP, null);
        for (int i = 0; i < nodeset.size(); ++i) {
            Element element = (Element)XPathUtil.getAsNode(nodeset, i + 1);
            String attributeValue = StrSubstitutor.replaceSystemProperties((Object)element.getAttribute(valueAttribute));
            map.put(element.getAttribute(nameAttribute), attributeValue);
        }
        return map;
    }

    private InstanceSerializerMap loadSerializer(NodeInfo configContext, String sectionPath, String scheme, String method, String mediatype, String serializerClass) throws Exception {
        InstanceSerializerMap map = new InstanceSerializerMap();
        List nodeset = XPathCache.getInstance().evaluate(configContext, sectionPath, Collections.EMPTY_MAP, null);
        for (int i = 0; i < nodeset.size(); ++i) {
            Element element = (Element)XPathUtil.getAsNode(nodeset, i + 1);
            try {
                String schemeVal = element.getAttribute(scheme);
                schemeVal = "".equals(schemeVal) ? "*" : schemeVal;
                String methodVal = element.getAttribute(method);
                methodVal = "".equals(methodVal) ? "*" : methodVal;
                String mediatypeVal = element.getAttribute(mediatype);
                mediatypeVal = "".equals(mediatypeVal) ? "*" : mediatypeVal;
                String classVal = element.getAttribute(serializerClass);
                if (classVal == null) continue;
                InstanceSerializer serializer = (InstanceSerializer)Class.forName(classVal).newInstance();
                map.registerSerializer(schemeVal, methodVal, mediatypeVal, serializer);
                continue;
            }
            catch (Exception e) {
                LOGGER.error((Object)("registerSerializer(\"" + scheme + "\",\"" + method + "\"," + mediatype + "\",\"" + serializerClass + "\") failed: " + e.getMessage()), (Throwable)e);
            }
        }
        return map;
    }

    private HashMap loadExtensionFunctions(NodeInfo configContext, String sectionPath) throws XFormsException {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        List nodeset = XPathCache.getInstance().evaluate(configContext, sectionPath, Collections.EMPTY_MAP, null);
        for (int i = 0; i < nodeset.size(); ++i) {
            String key;
            Element element = (Element)XPathUtil.getAsNode(nodeset, i + 1);
            String namespace = element.getAttribute("namespace");
            namespace = "".equals(namespace) ? null : namespace;
            String function = element.getAttribute("name");
            function = "".equals(function) ? null : function;
            String functionClass = element.getAttribute("class");
            String string = functionClass = "".equals(functionClass) ? null : functionClass;
            String string2 = namespace == null ? function : (key = namespace + (function == null ? "" : " " + function));
            if (function == null || functionClass == null) continue;
            String javaFunction = element.getAttribute("java-name");
            javaFunction = javaFunction == null || "".equalsIgnoreCase(javaFunction) ? function : javaFunction;
            String[] classFunction = new String[]{functionClass, javaFunction};
            if (key == null) continue;
            map.put(key, classFunction);
        }
        return map;
    }

    private HashMap loadCustomElements(NodeInfo configContext, String sectionPath) throws XFormsException {
        HashMap<String, String> map = new HashMap<String, String>();
        List nodeset = XPathCache.getInstance().evaluate(configContext, sectionPath, Collections.EMPTY_MAP, null);
        for (int i = 0; i < nodeset.size(); ++i) {
            String key;
            Element element = (Element)XPathUtil.getAsNode(nodeset, i + 1);
            String namespace = element.getAttribute("namespace");
            namespace = "".equals(namespace) ? null : namespace;
            String elementName = element.getAttribute("name");
            elementName = "".equals(elementName) ? null : elementName;
            String elementClass = element.getAttribute("class");
            String string = elementClass = "".equals(elementClass) ? null : elementClass;
            String string2 = namespace == null ? elementName : (key = namespace + (elementName == null ? "" : ":" + elementName));
            if (elementName == null || elementClass == null || key == null) continue;
            map.put(key, elementClass);
        }
        return map;
    }

    private String load(NodeInfo configContext, String path, String nameAttribute) throws Exception {
        Element element = (Element)XPathUtil.getAsNode(XPathCache.getInstance().evaluate(configContext, path, Collections.EMPTY_MAP, null), 1);
        String value = element.getAttribute(nameAttribute);
        return value;
    }
}

