/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.dom;

import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeFilter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMUtil {
    private static Log LOGGER = LogFactory.getLog(DOMUtil.class);

    public static Node getFragment(URI uri, InputStream xmlStream) throws XFormsException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        Document document = null;
        try {
            document = DOMUtil.parseInputStream(xmlStream, true, false);
        }
        catch (ParserConfigurationException e) {
            throw new XFormsException(e);
        }
        catch (SAXException e) {
            throw new XFormsException(e);
        }
        catch (IOException e) {
            throw new XFormsException(e);
        }
        if (uri.getFragment() != null) {
            String fragment = uri.getFragment();
            if (fragment.indexOf("?") != -1) {
                fragment = fragment.substring(0, fragment.indexOf("?"));
            }
            return DOMUtil.getById(document, fragment);
        }
        return document;
    }

    public static Node getById(Document in, String fragmentId) throws XFormsException {
        Node node = XPathUtil.evaluateAsSingleNode(in, "//*[@id eq '" + fragmentId + "']");
        return node;
    }

    public static Element getChildElement(Node start, String name) {
        NodeList nl = null;
        nl = start.getNodeType() == 9 ? ((Document)start).getDocumentElement().getChildNodes() : start.getChildNodes();
        int len = nl.getLength();
        Node n = null;
        for (int i = 0; i < len; ++i) {
            n = nl.item(i);
            if (n.getNodeType() != 1 || !n.getNodeName().equals(name)) continue;
            return (Element)n;
        }
        return null;
    }

    public static List getChildElements(Node start) {
        ArrayList<Node> l = new ArrayList<Node>();
        NodeList nl = start.getChildNodes();
        int len = nl.getLength();
        Node n = null;
        for (int i = 0; i < len; ++i) {
            n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            l.add(n);
        }
        return l;
    }

    public static int getCurrentListPosition(Node refNode, NodeList list) {
        if (refNode == null) {
            return -1;
        }
        int counter = 1;
        int n = 0;
        while (n < list.getLength()) {
            if (list.item(n) == refNode) {
                return counter;
            }
            ++n;
            ++counter;
        }
        return -1;
    }

    public static int getCurrentPosition(Node refNode) {
        if (refNode == null) {
            return -1;
        }
        int counter = 0;
        for (Node current = refNode; current != null; current = current.getPreviousSibling()) {
            if (current.getNodeType() != 1) continue;
            ++counter;
        }
        return counter;
    }

    public static int getCurrentNodesetPosition(Node refNode) {
        if (refNode == null) {
            return -1;
        }
        int counter = 0;
        String nodeName = refNode.getNodeName();
        for (Node current = refNode; current != null; current = current.getPreviousSibling()) {
            if (current.getNodeType() != 1 || !nodeName.equals(current.getNodeName())) continue;
            ++counter;
        }
        return counter;
    }

    public static Element getElementByAttributeValue(Node start, String tagName, String attrName, String attrValue) {
        NodeList nl = ((Element)start).getElementsByTagName(tagName);
        int l = nl.getLength();
        if (l == 0) {
            return null;
        }
        Element e = null;
        String compareValue = null;
        for (int i = 0; i < l; ++i) {
            e = (Element)nl.item(i);
            if (e.getNodeType() != 1 || !(compareValue = e.getAttribute(attrName)).equals(attrValue)) continue;
            return e;
        }
        return null;
    }

    public static Element getElementByAttributeValueNS(Node start, String tnuri, String tagName, String anuri, String attrName, String attrValue) {
        NodeList nl = ((Element)start).getElementsByTagNameNS(tnuri, tagName);
        if (nl != null) {
            int l = nl.getLength();
            if (l == 0) {
                return null;
            }
            Element e = null;
            String compareValue = null;
            for (int i = 0; i < l; ++i) {
                e = (Element)nl.item(i);
                if (e.getNodeType() != 1 || !(compareValue = e.getAttributeNS(anuri, attrName)).equals(attrValue)) continue;
                return e;
            }
        }
        return null;
    }

    public static Node getFirstChildByTagName(Node contextNode, String tag) {
        Node n = null;
        if (contextNode.getNodeType() == 9) {
            n = ((Document)contextNode).getDocumentElement();
            if (!n.getNodeName().equals(tag)) {
                n = null;
            }
        } else {
            NodeList nodes = ((Element)contextNode).getElementsByTagName(tag);
            if (nodes != null) {
                n = nodes.item(0);
            }
        }
        return n;
    }

    public static Node getFirstChildByTagNameNS(Node contextNode, String nsuri, String tag) {
        Node n = null;
        if (contextNode.getNodeType() == 9) {
            n = ((Document)contextNode).getDocumentElement();
            if (!n.getNamespaceURI().equals(nsuri) || !n.getNodeName().equals(tag)) {
                n = null;
            }
        } else {
            NodeList nodes = ((Element)contextNode).getElementsByTagNameNS(nsuri, tag);
            if (nodes != null) {
                n = nodes.item(0);
            }
        }
        return n;
    }

    public static Element getFirstChildElement(Node start) {
        Node n = null;
        NodeList nl = start.getChildNodes();
        int len = nl.getLength();
        if (len == 0) {
            return null;
        }
        for (int i = 0; i < len; ++i) {
            n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public static Element getLastChildElement(Node start) {
        NodeList children = start.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            Node n = null;
            for (int i = len - 1; i >= 0; --i) {
                n = children.item(i);
                if (n.getNodeType() != 1) continue;
                return (Element)n;
            }
        }
        return null;
    }

    public static Element getNextSiblingElement(Node node) {
        Node sibling = node.getNextSibling();
        if (sibling == null || sibling.getNodeType() == 1) {
            return (Element)sibling;
        }
        return DOMUtil.getNextSiblingElement(sibling);
    }

    public static boolean isNodeInNS(Node nodeToCompare, String nsuri, String tagName) {
        String ntcnsuri = nodeToCompare.getNamespaceURI();
        if (ntcnsuri != null && ntcnsuri.length() > 0) {
            return tagName.equals(nodeToCompare.getLocalName()) && ntcnsuri.equals(nsuri);
        }
        return tagName.equals(nodeToCompare.getNodeName());
    }

    public static Element getPreviousSiblingElement(Node node) {
        Node sibling = node.getPreviousSibling();
        if (sibling == null || sibling.getNodeType() == 1) {
            return (Element)sibling;
        }
        return DOMUtil.getPreviousSiblingElement(sibling);
    }

    public static Node getTextNode(Node start) {
        Node n = null;
        start.normalize();
        NodeList nl = start.getNodeType() == 9 ? ((Document)start).getDocumentElement().getChildNodes() : start.getChildNodes();
        int len = nl.getLength();
        if (len == 0) {
            return null;
        }
        for (int i = 0; i < len; ++i) {
            n = nl.item(i);
            if (n.getNodeType() == 3) {
                return n;
            }
            if (n.getNodeType() != 4) continue;
            return n;
        }
        return null;
    }

    public static String getTextNodeAsString(Node start) {
        Node txt = DOMUtil.getTextNode(start);
        if (txt != null) {
            return txt.getNodeValue();
        }
        return "";
    }

    public static String getElementValue(Element element) {
        Node child = element.getFirstChild();
        if (child != null) {
            return child.getNodeValue();
        }
        return null;
    }

    public static void setElementValue(Element element, String value) {
        Node child = element.getFirstChild();
        if (value != null) {
            if (child == null) {
                child = element.getOwnerDocument().createTextNode("");
                element.appendChild(child);
            }
            child.setNodeValue(value);
        } else if (child != null) {
            element.removeChild(child);
        }
    }

    public static void copyAttributes(Element from, Element to, NodeFilter filter) {
        if (from != null && to != null) {
            NamedNodeMap map = from.getAttributes();
            if (filter == null) {
                filter = new NodeFilter(){

                    @Override
                    public short acceptNode(Node n) {
                        return 1;
                    }
                };
            }
            if (map != null) {
                int len = map.getLength();
                for (int i = 0; i < len; ++i) {
                    Node attr = map.item(i);
                    if (attr.getNodeType() != 2 || filter.acceptNode(attr) != 1) continue;
                    to.setAttributeNS(attr.getNamespaceURI(), attr.getNodeName(), attr.getNodeValue());
                }
            }
        }
    }

    public static int countChildElements(Node node) {
        NodeList nl = node.getChildNodes();
        int count = 0;
        for (int n = 0; n < nl.getLength(); ++n) {
            if (nl.item(n).getNodeType() != 1) continue;
            ++count;
        }
        return count;
    }

    public static Element findFirstChild(Node parent, String tagName) {
        if (tagName == null) {
            return null;
        }
        NodeList children = parent.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            Node n = null;
            for (int i = 0; i < len; ++i) {
                n = children.item(i);
                if (n.getNodeType() != 1 || !tagName.equals(n.getNodeName())) continue;
                return (Element)n;
            }
        }
        return null;
    }

    public static Element findFirstChildNS(Node parent, String nsuri, String tagName) {
        if (tagName == null) {
            return null;
        }
        NodeList children = parent.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            Node n = null;
            for (int i = 0; i < len; ++i) {
                n = children.item(i);
                if (n.getNodeType() != 1 || !DOMUtil.isNodeInNS(n, nsuri, tagName)) continue;
                return (Element)n;
            }
        }
        return null;
    }

    public static Element findLastChild(Node parent, String tagName) {
        if (tagName == null) {
            return null;
        }
        NodeList children = parent.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            Node n = null;
            for (int i = len - 1; i >= 0; --i) {
                n = children.item(i);
                if (n.getNodeType() != 1 || !tagName.equals(n.getNodeName())) continue;
                return (Element)n;
            }
        }
        return null;
    }

    public static Element findLastChildNS(Node parent, String nsuri, String tagName) {
        if (tagName == null) {
            return null;
        }
        NodeList children = parent.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            Node n = null;
            for (int i = len - 1; i >= 0; --i) {
                n = children.item(i);
                if (n.getNodeType() != 1 || !DOMUtil.isNodeInNS(n, nsuri, tagName)) continue;
                return (Element)n;
            }
        }
        return null;
    }

    public static Node findNthChildNS(Node contextNode, String nsuri, String tag, int idx) {
        if (tag == null) {
            return null;
        }
        NodeList children = contextNode.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            Node n = null;
            int childcount = 1;
            for (int i = 0; i < len; ++i) {
                n = children.item(i);
                if (n.getNodeType() != 1 || !DOMUtil.isNodeInNS(n, nsuri, tag)) continue;
                if (childcount == idx) {
                    return (Element)n;
                }
                if (childcount > idx) {
                    return null;
                }
                ++childcount;
            }
        }
        return null;
    }

    public static boolean hasChild(Element start, String name) {
        NodeList nl = start.getChildNodes();
        int len = nl.getLength();
        Node n = null;
        for (int i = 0; i < len; ++i) {
            n = nl.item(i);
            if (!n.getNodeName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasElementChildren(Element element) {
        return DOMUtil.hasNonWhitespaceChildren(element);
    }

    public static boolean hasNonWhitespaceChildren(Element element) {
        if (element.hasChildNodes()) {
            NodeList children = element.getChildNodes();
            int len = children.getLength();
            Node n = null;
            for (int i = 0; i < len; ++i) {
                n = children.item(i);
                if (n.getNodeType() != 1) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static Node importAndAppendNode(Document document, Node toImport) {
        if (toImport != null) {
            Node imported = document.importNode(toImport, true);
            return document.appendChild(imported);
        }
        return null;
    }

    public static Node importNode(Document document, Node toImport) {
        if (toImport != null) {
            Node root = toImport.cloneNode(false);
            root = document.importNode(root, false);
            for (Node n = toImport.getFirstChild(); n != null; n = n.getNextSibling()) {
                root.appendChild(document.importNode(n, true));
            }
            return root;
        }
        return null;
    }

    public static void insertAfter(Node newChild, Node refChild) throws DOMException {
        if (refChild == null) {
            throw new DOMException(8, "refChild == null");
        }
        Node nextSibling = refChild.getNextSibling();
        if (nextSibling == null) {
            refChild.getParentNode().appendChild(newChild);
        } else {
            refChild.getParentNode().insertBefore(newChild, nextSibling);
        }
    }

    public static void moveChild(NodeList nodelist, int index, int step) {
        if (nodelist == null || nodelist.getLength() == 0) {
            return;
        }
        if (index >= nodelist.getLength() || index < 0) {
            return;
        }
        if (step == 0) {
            return;
        }
        Node parent = nodelist.item(0).getParentNode();
        Node deletedElt = parent.removeChild(nodelist.item(index));
        if (index + step == nodelist.getLength() - 1) {
            parent.appendChild(deletedElt);
        } else if (step < 0) {
            parent.insertBefore(deletedElt, nodelist.item(index + step));
        } else {
            parent.insertBefore(deletedElt, nodelist.item(index + step + 1));
        }
    }

    public static void removeAllChildren(Node node) {
        Node child;
        while ((child = node.getFirstChild()) != null) {
            node.removeChild(child);
        }
    }

    public static Document newDocument(boolean isNamespaceAware, boolean isValidating) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(isNamespaceAware);
        factory.setValidating(isValidating);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            System.err.println(pce.toString());
            return null;
        }
    }

    public static Document parseInputStream(InputStream in, boolean namespaces, boolean validating) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = DOMUtil.createDocumentBuilder(namespaces, validating);
        return builder.parse(in);
    }

    public static Document parseXmlFile(String fileName, boolean namespaces, boolean validating) throws ParserConfigurationException, SAXException, IOException {
        return DOMUtil.parseXmlFile(new File(fileName), namespaces, validating);
    }

    public static Document parseXmlFile(File file, boolean namespaces, boolean validating) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = DOMUtil.createDocumentBuilder(namespaces, validating);
        return builder.parse(file);
    }

    public static Document parseString(String input, boolean namespaces, boolean validating) throws ParserConfigurationException, IOException, SAXException {
        return DOMUtil.createDocumentBuilder(true, false).parse(new InputSource(new StringReader(input)));
    }

    public static void prettyPrintDOM(Node node) {
        try {
            System.out.println();
            DOMUtil.prettyPrintDOM(node, System.out);
            System.out.println("\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void prettyPrintDOM(Node node, OutputStream stream) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.transform(new DOMSource(node), new StreamResult(stream));
    }

    public static void prettyPrintDOM(Node node, Node output) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.transform(new DOMSource(node), new DOMResult(node));
    }

    public static void prettyPrintDOMAsHTML(Node node, OutputStream stream) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "html");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(new DOMSource(node), new StreamResult(stream));
    }

    private static DocumentBuilder createDocumentBuilder(boolean namespaces, boolean validating) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(namespaces);
        factory.setValidating(validating);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder;
    }

    public static String getCanonicalPath(Node node) {
        if (node == null) {
            return "";
        }
        if (node.getNodeType() == 9) {
            return "/";
        }
        String ns = node.getNamespaceURI();
        String nodeName1 = node.getNodeName();
        String nodeName2 = node.getLocalName();
        String canonPath = ns != null && ns.equals("http://www.w3.org/1999/xhtml") && node.getNodeName().equals(node.getLocalName()) ? "html:" + node.getNodeName() : node.getNodeName();
        if (node.getNodeType() == 2) {
            canonPath = "@" + canonPath;
        } else if (node.getNodeType() == 1) {
            int position = DOMUtil.getCurrentNodesetPosition(node);
            canonPath = canonPath + "[" + position + "]";
        }
        Node parent = null;
        if (node.getNodeType() == 1 || node.getNodeType() == 3) {
            parent = node.getParentNode();
        } else if (node.getNodeType() == 2) {
            parent = ((Attr)node).getOwnerElement();
        }
        if (parent == null) {
            parent = node.getOwnerDocument().getDocumentElement();
        }
        canonPath = parent.getNodeType() == 9 || parent.getNodeType() == 11 ? "/" + canonPath : DOMUtil.getCanonicalPath(parent) + "/" + canonPath;
        return canonPath;
    }

    public static String serializeToString(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(domSource, result);
            writer.flush();
            return writer.toString();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Element createRootElement(String rootNodeName) {
        Document inputDoc = DOMUtil.newDocument(false, false);
        Element rootNode = inputDoc.createElement(rootNodeName);
        inputDoc.appendChild(rootNode);
        return rootNode;
    }

    public static void appendElement(Element parent, String elementName, String value) {
        Element e = parent.getOwnerDocument().createElement(elementName);
        DOMUtil.setElementValue(e, value);
        parent.appendChild(e);
    }
}

