/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.dom;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NodeList;

public class DOMWhitespace {
    public static boolean isWhitespace(String string) {
        if (string != null) {
            for (int index = 0; index < string.length(); ++index) {
                if (Character.isWhitespace(string.charAt(index))) continue;
                return false;
            }
        }
        return true;
    }

    public static int skipComments(NodeList list, int start) {
        for (int index = start; index < list.getLength(); ++index) {
            if (list.item(index).getNodeType() == 8) continue;
            return index;
        }
        return list.getLength();
    }

    public static int skipWhitespace(NodeList list, int start) {
        for (int index = start; index < list.getLength(); ++index) {
            if (list.item(index).getNodeType() != 3) {
                return index;
            }
            if (DOMWhitespace.isWhitespace(list.item(index).getNodeValue())) continue;
            return index;
        }
        return list.getLength();
    }

    public static int skipWhitespaceAndComments(NodeList list, int start) {
        for (int index = start; index < list.getLength(); ++index) {
            if (list.item(index) == null) {
                return index;
            }
            if (list.item(index).getNodeType() != 8 && list.item(index).getNodeType() != 3) {
                return index;
            }
            if (list.item(index).getNodeType() != 3 || DOMWhitespace.isWhitespace(list.item(index).getNodeValue())) continue;
            return index;
        }
        return list.getLength();
    }

    public static List denormalizeText(String text) {
        if (text == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        if (text.length() == 0) {
            list.add(text);
            return list;
        }
        int start = 0;
        boolean whitespace = Character.isWhitespace(text.charAt(start));
        for (int index = 0; index < text.length(); ++index) {
            if (whitespace && !Character.isWhitespace(text.charAt(index))) {
                list.add(text.substring(start, index));
                start = index;
                whitespace = false;
            }
            if (whitespace || !Character.isWhitespace(text.charAt(index)) || (index + 1 >= text.length() || !Character.isWhitespace(text.charAt(index + 1))) && index + 1 != text.length()) continue;
            list.add(text.substring(start, index));
            start = index;
            whitespace = true;
        }
        list.add(text.substring(start, text.length()));
        return list;
    }
}

