/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.events.impl;

import de.betterform.xml.events.XMLEvent;
import de.betterform.xml.events.XMLEventInitializer;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultXMLEventInitializer
implements XMLEventInitializer {
    private static final Log LOGGER = LogFactory.getLog(DefaultXMLEventInitializer.class);
    private static final short EVENT_BUBBLES = 0;
    private static final short EVENT_CANCELABLE = 1;
    private static final short EVENT_CONTEXT = 2;
    private static final HashMap INITIALIZATION_RULES = new HashMap();

    @Override
    public void initXMLEvent(XMLEvent event, String type, boolean bubbles, boolean cancelable, Object context) {
        boolean[] rules = (boolean[])INITIALIZATION_RULES.get(type);
        if (rules != null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("initializing event " + type + " from rule: bubbles=" + rules[0] + ", cancelable=" + rules[1] + ", context=" + (rules[2] ? "yes" : "no")));
            }
            event.initXMLEvent(type, rules[0], rules[1], rules[2] ? context : null);
        } else {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("initializing event " + type + " from parameters: bubbles=" + bubbles + ", cancelable=" + cancelable + ", context=" + (context != null ? "yes" : "no")));
            }
            event.initXMLEvent(type, bubbles, cancelable, context);
        }
    }

    static {
        INITIALIZATION_RULES.put("xforms-model-construct", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-model-construct-done", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-ready", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-model-destruct", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-previous", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-next", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-focus", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-help", new boolean[]{true, true, false});
        INITIALIZATION_RULES.put("xforms-hint", new boolean[]{true, true, false});
        INITIALIZATION_RULES.put("xforms-rebuild", new boolean[]{true, true, false});
        INITIALIZATION_RULES.put("xforms-refresh", new boolean[]{true, true, false});
        INITIALIZATION_RULES.put("xforms-revalidate", new boolean[]{true, true, false});
        INITIALIZATION_RULES.put("xforms-recalculate", new boolean[]{true, true, false});
        INITIALIZATION_RULES.put("xforms-reset", new boolean[]{true, true, false});
        INITIALIZATION_RULES.put("xforms-submit", new boolean[]{true, true, false});
        INITIALIZATION_RULES.put("DOMActivate", new boolean[]{true, true, true});
        INITIALIZATION_RULES.put("xforms-value-changed", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-select", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-deselect", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-scroll-first", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-scroll-last", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-insert", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("xforms-delete", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("xforms-valid", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-invalid", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("DOMFocusIn", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("DOMFocusOut", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-readonly", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-readwrite", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-required", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-optional", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-enabled", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-disabled", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-in-range", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-out-of-range", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-output-error", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-submit-done", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("xforms-submit-error", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("xforms-binding-exception", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("xforms-link-exception", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("xforms-link-error", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("xforms-compute-exception", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("betterform-load-uri", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("betterform-render-message", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("betterform-replace-all", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("betterform-replace-all-xforms", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("betterform-state-changed", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("betterform-node-inserted", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("betterform-node-deleted", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("betterform-prototype-cloned", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("betterform-id-generated", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("betterform-item-inserted", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("betterform-item-deleted", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("betterform-item-changed", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("betterform-index-changed", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("betterform-switch-toggled", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("betterform-custom-mip-changed", new boolean[]{true, false, true});
    }
}

