/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms;

import de.betterform.connector.ConnectorFactory;
import de.betterform.xml.config.XFormsConfigException;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.events.XMLEventService;
import de.betterform.xml.ns.NamespaceResolver;
import de.betterform.xml.xforms.CustomElementFactory;
import de.betterform.xml.xforms.Initializer;
import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.XFormsElementFactory;
import de.betterform.xml.xforms.XFormsProcessorImpl;
import de.betterform.xml.xforms.exception.XFormsErrorIndication;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.bind.BindingResolver;
import de.betterform.xml.xforms.ui.AbstractFormControl;
import de.betterform.xml.xforms.ui.Group;
import de.betterform.xml.xforms.ui.Repeat;
import de.betterform.xml.xforms.ui.Switch;
import de.betterform.xml.xpath.impl.saxon.BetterFormXPathContext;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DocumentWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.xforms.XFormsModelElement;

public class Container {
    private static final Log LOGGER = LogFactory.getLog(Container.class);
    private final Configuration fConfiguration = new Configuration();
    private BindingResolver bindingResolver;
    private XFormsProcessorImpl processor;
    private ConnectorFactory connectorFactory;
    private Document document;
    private Element root;
    private XMLEventService eventService;
    private List<Model> models;
    private Map xFormsElements;
    private XFormsElementFactory elementFactory;
    private CustomElementFactory customElementFactory;
    private boolean modelConstructDone = false;
    private int idCounter = 0;
    private List eventExceptions;
    public static final String XFORMS_1_0 = "1.0";
    public static final String XFORMS_1_1 = "1.1";
    private BetterFormXPathContext hostContext;
    private String version;
    private Stack<EventInfo> fEventInfoStack = new Stack();
    private String focussedControlId = null;
    private String focussedContainerId = null;
    private Map<Document, DocumentWrapper> fgDocumentWrapperCache = new HashMap<Document, DocumentWrapper>();

    public Container(XFormsProcessorImpl processor) {
        this.processor = processor;
    }

    public XFormsProcessorImpl getProcessor() {
        return this.processor;
    }

    public BindingResolver getBindingResolver() {
        if (this.bindingResolver == null) {
            this.bindingResolver = new BindingResolver();
        }
        return this.bindingResolver;
    }

    public ConnectorFactory getConnectorFactory() {
        if (this.connectorFactory == null) {
            try {
                this.connectorFactory = ConnectorFactory.getFactory();
                this.connectorFactory.setContext(this.processor.getContext());
            }
            catch (XFormsConfigException xce) {
                throw new RuntimeException(xce);
            }
        }
        return this.connectorFactory;
    }

    public XFormsElementFactory getElementFactory() {
        if (this.elementFactory == null) {
            this.elementFactory = new XFormsElementFactory();
        }
        return this.elementFactory;
    }

    public CustomElementFactory getCustomElementFactory() throws XFormsException {
        if (this.customElementFactory == null) {
            this.customElementFactory = new CustomElementFactory();
        }
        return this.customElementFactory;
    }

    public XMLEventService getXMLEventService() {
        return this.eventService;
    }

    public String getFocussedControlId() {
        return this.focussedControlId;
    }

    public void setFocussedControlId(String id) {
        this.focussedControlId = id;
    }

    public String getFocussedContainerId() {
        return this.focussedContainerId;
    }

    public void setFocussedContainerId(String id) {
        this.focussedContainerId = id;
    }

    public void setXMLEventService(XMLEventService eventService) {
        this.eventService = eventService;
    }

    public void setDocument(Document document) {
        this.document = document;
        this.root = this.document.getDocumentElement();
        if (!this.root.hasAttributeNS("http://www.w3.org/2000/xmlns/", "bf")) {
            this.root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:bf", "http://betterform.sourceforge.net/xforms");
        }
        NamespaceResolver.init(this.root);
    }

    public Document getDocument() {
        return this.document;
    }

    public void init() throws XFormsException {
        this.root.setUserData("", this, null);
        this.initModels();
    }

    public String getVersion() throws XFormsException {
        return this.version;
    }

    public void shutdown() throws XFormsException {
        if (this.models != null) {
            for (int index = 0; index < this.models.size(); ++index) {
                Model model = this.models.get(index);
                this.dispatch(model.getTarget(), "xforms-model-destruct", null);
            }
        }
    }

    public void addEventListener(String targetId, String eventType, EventListener eventListener, boolean useCapture) throws XFormsException {
        EventTarget eventTarget = this.lookupEventTarget(targetId);
        if (eventTarget != null) {
            eventTarget.addEventListener(eventType, eventListener, useCapture);
            return;
        }
        throw new XFormsException("Unable to add eventlistener. Event target '" + targetId + "' not found");
    }

    public void removeEventListener(String targetId, String eventType, EventListener eventListener, boolean useCapture) throws XFormsException {
        EventTarget eventTarget = this.lookupEventTarget(targetId);
        if (eventTarget != null) {
            eventTarget.addEventListener(eventType, eventListener, useCapture);
            return;
        }
        throw new XFormsException("Unable to remove eventlistener. Event target '" + targetId + "' not found");
    }

    public boolean dispatch(String targetId, String eventType) throws XFormsException {
        return this.dispatch(targetId, eventType, null);
    }

    public boolean dispatch(String targetId, String eventType, Object info) throws XFormsException {
        return this.dispatch(targetId, eventType, info, true, true);
    }

    public boolean dispatch(String targetId, String eventType, Object info, boolean bubbles, boolean cancelable) throws XFormsException {
        EventTarget eventTarget;
        XFormsElement xFormsElement = this.lookup(targetId);
        if (xFormsElement != null && xFormsElement instanceof AbstractFormControl && ("DOMFocusIn".equals(eventType) || "DOMFocusOut".equals(eventType))) {
            XFormsElement parent;
            if (!this.xFormsElements.containsKey(this.focussedContainerId)) {
                this.focussedContainerId = null;
            }
            if ((parent = xFormsElement.getEnclosingXFormsContainer()) == null) {
                if (this.focussedContainerId != null) {
                    this.dispatch(this.focussedContainerId, "DOMFocusOut");
                }
                this.focussedContainerId = null;
            } else if ((parent instanceof Group || parent instanceof Switch || parent instanceof Repeat) && !parent.getId().equals(this.focussedContainerId)) {
                if (this.focussedContainerId != null) {
                    this.dispatch(this.focussedContainerId, "DOMFocusOut");
                }
                this.focussedContainerId = parent.getId();
                if ("DOMFocusIn".equals(eventType)) {
                    this.dispatch(parent.getId(), "DOMFocusIn");
                }
            }
        }
        if ((eventTarget = this.lookupEventTarget(targetId)) != null) {
            return this.dispatch(eventTarget, eventType, info, bubbles, cancelable);
        }
        throw new XFormsException("event target '" + targetId + "' not found for event '" + eventType + "'");
    }

    public boolean dispatch(EventTarget eventTarget, String eventType, Object info) throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("dispatching event '" + eventType + "' to target '" + DOMUtil.getCanonicalPath((Node)((Object)eventTarget)) + "'"));
        }
        return this.dispatch(eventTarget, eventType, info, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatch(EventTarget eventTarget, String eventType, Object info, boolean bubbles, boolean cancelable) throws XFormsException {
        boolean result = false;
        XFormsException xFormsException = null;
        try {
            this.fEventInfoStack.push(new EventInfo(eventTarget, eventType, info, bubbles, cancelable));
            result = this.eventService.dispatch(eventTarget, eventType, bubbles, cancelable, info);
        }
        finally {
            this.fEventInfoStack.pop();
            if (this.eventExceptions != null && this.eventExceptions.size() > 0) {
                Exception exception = (Exception)this.eventExceptions.get(0);
                if (exception instanceof XFormsErrorIndication) {
                    if (((XFormsErrorIndication)exception).isFatal()) {
                        xFormsException = (XFormsException)exception;
                    } else {
                        LOGGER.warn((Object)"dispatch: non-fatal xforms error", (Throwable)exception);
                    }
                } else {
                    xFormsException = exception instanceof XFormsException ? (XFormsException)exception : new XFormsException(exception);
                }
                this.eventExceptions.clear();
            }
        }
        if (xFormsException != null) {
            LOGGER.error((Object)"dispatch: exception during event flow", (Throwable)xFormsException);
            throw xFormsException;
        }
        return result;
    }

    public void handleEventException(Exception exception) {
        LOGGER.warn((Object)("handle event exception: " + exception.getClass().getName() + " kept for rethrowal after dispatch() has finished"));
        if (this.eventExceptions == null) {
            this.eventExceptions = new ArrayList();
        }
        if (exception instanceof XFormsErrorIndication) {
            XFormsErrorIndication indication = (XFormsErrorIndication)exception;
            LOGGER.warn((Object)("XForms Error: " + indication.getMessage()));
            if (!indication.isHandled()) {
                try {
                    this.dispatch(indication.getEventTarget(), indication.getEventType(), indication.getContextInfo());
                }
                catch (XFormsException e) {
                    LOGGER.error((Object)"handle event exception: exception during error indication event", (Throwable)e);
                }
                indication.setHandled();
            }
        }
        this.eventExceptions.add(exception);
    }

    public XFormsElement lookup(String id) {
        if (this.xFormsElements != null) {
            return (XFormsElement)this.xFormsElements.get(id);
        }
        return null;
    }

    public String generateId() {
        String id = "C" + ++this.idCounter;
        while (this.lookup(id) != null) {
            id = "C" + ++this.idCounter;
        }
        return id;
    }

    public void register(XFormsElement element) {
        if (this.xFormsElements == null) {
            this.xFormsElements = new HashMap();
        }
        this.xFormsElements.put(element.getId(), element);
    }

    public void deregister(XFormsElement element) {
        if (this.xFormsElements != null) {
            this.xFormsElements.remove(element.getId());
        }
    }

    public Model getDefaultModel() throws XFormsException {
        return this.getModel(null);
    }

    public Model getModel(String id) throws XFormsException {
        if (id == null || id.length() == 0) {
            if (this.models != null && this.models.size() > 0) {
                return this.models.get(0);
            }
            throw new XFormsException("default model not found");
        }
        if (this.models != null) {
            for (int index = 0; index < this.models.size(); ++index) {
                Model model = this.models.get(index);
                if (!model.getId().equals(id)) continue;
                return model;
            }
        }
        throw new XFormsException("model '" + id + "' not found");
    }

    public List getModels() {
        return this.models;
    }

    public boolean isModelConstructDone() {
        return this.modelConstructDone;
    }

    private void initModels() throws XFormsException {
        Model model;
        int i;
        this.models = new ArrayList<Model>();
        List<Element> modelElements = this.getModelElements();
        int nrOfModels = modelElements.size();
        if (nrOfModels == 0) {
            return;
        }
        for (i = 0; i < nrOfModels; ++i) {
            Element modelElement = modelElements.get(i);
            model = (Model)this.getElementFactory().createXFormsElement(modelElement, null);
            this.models.add(model);
        }
        for (i = 0; i < nrOfModels; ++i) {
            boolean isCompatible = true;
            model = this.models.get(i);
            model.init();
            if (i == 0) {
                isCompatible = this.checkVersionCompatibility();
            }
            if (!isCompatible) {
                return;
            }
            Initializer.initializeModelConstructActionElements(model, model.getElement());
            this.dispatch(model.getTarget(), "xforms-model-construct", null);
        }
        for (i = 0; i < nrOfModels; ++i) {
            model = this.models.get(i);
            this.dispatch(model.getTarget(), "xforms-model-construct-done", null);
            this.modelConstructDone = true;
        }
        for (i = 0; i < nrOfModels; ++i) {
            model = this.models.get(i);
            this.dispatch(model.getTarget(), "xforms-ready", null);
        }
    }

    public void createEmbeddedForm(Element startElement) throws XFormsException {
        Model model2;
        List<Element> modelElements = this.getModelElements(startElement);
        int nrOfModels = modelElements.size();
        ArrayList<Model> embeddedModels = new ArrayList<Model>(nrOfModels);
        for (int i = 0; i < nrOfModels; ++i) {
            Element modelElement = modelElements.get(i);
            model2 = (Model)this.getElementFactory().createXFormsElement(modelElement, null);
            this.models.add(model2);
            embeddedModels.add(model2);
        }
        boolean isCompatible = false;
        for (int i = 0; i < nrOfModels; ++i) {
            if (i == 0) {
                isCompatible = this.checkVersionCompatibility();
            }
            model2 = (Model)embeddedModels.get(i);
            model2.init();
            if (!isCompatible) {
                return;
            }
            this.dispatch(model2.getTarget(), "xforms-model-construct", null);
        }
        for (Model model2 : embeddedModels) {
            this.dispatch(model2.getTarget(), "xforms-model-construct-done", null);
            Initializer.initializeUIElements(model2, startElement, null, null);
        }
        for (Model model2 : embeddedModels) {
            this.dispatch(model2.getTarget(), "xforms-ready", null);
        }
    }

    private List<Element> getModelElements(Element start) {
        ArrayList<Element> result = new ArrayList<Element>();
        this.addModelElements(start, result);
        return result;
    }

    private List<Element> getModelElements() {
        return this.getModelElements(this.root);
    }

    private void addModelElements(Node parent, List<Element> models) {
        for (Node it = parent.getFirstChild(); it != null; it = it.getNextSibling()) {
            if (it.getNodeType() != 1) continue;
            if ("http://www.w3.org/2002/xforms".equals(it.getNamespaceURI())) {
                Element el = (Element)it;
                if ("model".equals(el.getLocalName())) {
                    models.add(el);
                    continue;
                }
                this.addModelElements(it, models);
                continue;
            }
            this.addModelElements(it, models);
        }
    }

    public void removeModel(Model model) {
        if (this.models.contains(model)) {
            this.models.remove(model);
        }
    }

    public Element getElementById(String id) throws XFormsException {
        String baseURI = this.getProcessor().getBaseURI();
        return (Element)XPathCache.getInstance().evaluateAsSingleNode(this.getHostContext(baseURI), "//*[@id='" + id + "']");
    }

    public BetterFormXPathContext getHostContext(String baseURI) {
        if (this.hostContext == null) {
            List nodes = XPathUtil.getRootContext(this.document, baseURI);
            this.hostContext = new BetterFormXPathContext(nodes, 1, Collections.EMPTY_MAP, null);
        }
        return this.hostContext;
    }

    private EventTarget lookupEventTarget(String id) throws XFormsException {
        XFormsElement xFormsElement = this.lookup(id);
        if (xFormsElement != null) {
            return xFormsElement.getTarget();
        }
        return (EventTarget)((Object)this.getElementById(id));
    }

    private boolean checkVersionCompatibility() throws XFormsException {
        String versionString = null;
        Element defaultModelElement = this.models.get(0).getElement();
        for (int i = 0; i < this.models.size(); ++i) {
            Element modelElement = this.models.get(i).getElement();
            versionString = XFormsElement.getXFormsAttribute(modelElement, "version");
            if (i == 0) {
                this.version = this.checkForValidVersion(versionString);
                if (this.version != null) continue;
                HashMap<String, String> contextInfo = new HashMap<String, String>();
                contextInfo.put("error-information", "version setting of default model not supported: '" + versionString + "'");
                this.dispatch((EventTarget)((Object)defaultModelElement), "xforms-version-exception", contextInfo);
                return false;
            }
            String versionTmp = this.checkForValidVersion(versionString);
            if (versionTmp != null && versionTmp.compareTo(this.version) <= 0) continue;
            HashMap<String, String> contextInfo = new HashMap<String, String>();
            contextInfo.put("error-information", "Incompatible version setting: " + versionString + " on model: " + DOMUtil.getCanonicalPath(modelElement));
            this.dispatch((EventTarget)((Object)defaultModelElement), "xforms-version-exception", contextInfo);
            return false;
        }
        LOGGER.info((Object)("running XForms version" + this.version));
        return true;
    }

    protected String checkForValidVersion(String versionAttribute) {
        String versionTmp = null;
        if (versionAttribute == null || versionAttribute.equals("")) {
            return XFORMS_1_1;
        }
        String[] versionArray = versionAttribute.trim().split(" ");
        for (int j = 0; j < versionArray.length; ++j) {
            if (XFORMS_1_1.equals(versionArray[j])) {
                return XFORMS_1_1;
            }
            if (!XFORMS_1_0.equals(versionArray[j])) continue;
            versionTmp = XFORMS_1_0;
        }
        return versionTmp;
    }

    public void refresh() throws XFormsException {
        if (this.isModelConstructDone()) {
            List models = this.getModels();
            for (int i = 0; i < models.size(); ++i) {
                XFormsModelElement model = (XFormsModelElement)models.get(i);
                model.refresh();
            }
        }
    }

    public EventInfo getCurrentEventInfo() {
        if (this.fEventInfoStack.isEmpty()) {
            return null;
        }
        return this.fEventInfoStack.peek();
    }

    public Configuration getConfiguration() {
        return this.fConfiguration;
    }

    public DocumentWrapper getDocumentWrapper(Node n) {
        Document ownerDocument = n.getOwnerDocument();
        DocumentWrapper documentWrapper = this.fgDocumentWrapperCache.get(ownerDocument);
        if (documentWrapper == null) {
            documentWrapper = new DocumentWrapper((Node)ownerDocument, this.getProcessor().getBaseURI(), this.getConfiguration());
            this.fgDocumentWrapperCache.put(ownerDocument, documentWrapper);
        }
        return documentWrapper;
    }

    public static class EventInfo {
        private final EventTarget eventTarget;
        private final String eventType;
        private final Object info;
        private final boolean bubbles;
        private final boolean cancelable;

        public EventInfo(EventTarget eventTarget, String eventType, Object info, boolean bubbles, boolean cancelable) {
            this.eventTarget = eventTarget;
            this.eventType = eventType;
            this.info = info;
            this.bubbles = bubbles;
            this.cancelable = cancelable;
        }

        public EventTarget getEventTarget() {
            return this.eventTarget;
        }

        public String getEventType() {
            return this.eventType;
        }

        public Object getInfo() {
            return this.info;
        }

        public boolean bubbles() {
            return this.bubbles;
        }

        public boolean isCancelable() {
            return this.cancelable;
        }
    }
}

