/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms;

import de.betterform.xml.xforms.Container;
import de.betterform.xml.xforms.CustomElementFactory;
import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.XFormsElementFactory;
import de.betterform.xml.xforms.action.AbstractAction;
import de.betterform.xml.xforms.exception.XFormsBindingException;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.bind.Bind;
import de.betterform.xml.xforms.model.submission.Header;
import de.betterform.xml.xforms.model.submission.Submission;
import de.betterform.xml.xforms.ui.AVTElement;
import de.betterform.xml.xforms.ui.AbstractUIElement;
import de.betterform.xml.xpath.XPathReferenceFinder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.EventTarget;

public class Initializer {
    private Initializer() {
    }

    public static void initializeModelConstructActionElements(Model model, Element element) throws XFormsException {
        XFormsElementFactory elementFactory = model.getContainer().getElementFactory();
        CustomElementFactory customFactory = model.getContainer().getCustomElementFactory();
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node node = childNodes.item(index);
            if (node.getNodeType() != 1) continue;
            Element elementImpl = (Element)node;
            String eventType = ((Element)node).getAttributeNS("http://www.w3.org/2001/xml-events", "event");
            if (!"xforms-model-construct".equals(eventType)) continue;
            if (XFormsElementFactory.isActionElement(elementImpl)) {
                Initializer.initializeActionElement(model, null, elementFactory, elementImpl);
                continue;
            }
            if (!customFactory.isCustomElement(elementImpl)) continue;
            Initializer.initializeCustomActionElement(model, null, customFactory, elementImpl);
        }
    }

    public static void initializeActionElements(Model model, Element element) throws XFormsException {
        Initializer.initializeActionElements(model, element, null);
    }

    public static void initializeActionElements(Model model, Element element, String repeatItemId) throws XFormsException {
        XFormsElementFactory elementFactory = model.getContainer().getElementFactory();
        CustomElementFactory customFactory = model.getContainer().getCustomElementFactory();
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node node = childNodes.item(index);
            if (node.getNodeType() != 1) continue;
            Element elementImpl = (Element)node;
            String eventType = ((Element)node).getAttributeNS("http://www.w3.org/2001/xml-events", "event");
            if ("xforms-model-construct".equals(eventType)) continue;
            if (XFormsElementFactory.isActionElement(elementImpl)) {
                Initializer.initializeActionElement(model, repeatItemId, elementFactory, elementImpl);
                continue;
            }
            if (!customFactory.isCustomElement(elementImpl)) continue;
            Initializer.initializeCustomActionElement(model, repeatItemId, customFactory, elementImpl);
        }
    }

    private static void initializeCustomActionElement(Model model, String repeatItemId, CustomElementFactory customFactory, Element elementImpl) throws XFormsException {
        Model contextModel = Initializer.getContextModel(model, elementImpl);
        Object customElement = customFactory.createCustomXFormsElement(elementImpl, contextModel);
        if (customElement != null && customElement instanceof AbstractAction) {
            Initializer.initXFormsObject(model, repeatItemId, (AbstractAction)customElement);
        }
    }

    private static void initializeActionElement(Model model, String repeatItemId, XFormsElementFactory elementFactory, Element elementImpl) throws XFormsException {
        Model contextModel = Initializer.getContextModel(model, elementImpl);
        AbstractAction actionElement = (AbstractAction)elementFactory.createXFormsElement(elementImpl, contextModel);
        Initializer.initXFormsObject(model, repeatItemId, actionElement);
    }

    public static void initializeBindElements(Model model, Element element, XPathReferenceFinder referenceFinder) throws XFormsException {
        XFormsElementFactory elementFactory = model.getContainer().getElementFactory();
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Element elementImpl;
            Node node = childNodes.item(index);
            if (node.getNodeType() != 1 || !XFormsElementFactory.isBindElement(elementImpl = (Element)node)) continue;
            Bind bindElement = (Bind)elementFactory.createXFormsElement(elementImpl, model);
            bindElement.setReferenceFinder(referenceFinder);
            bindElement.init();
        }
    }

    public static void initializeSubmissionElements(Model model, Element element) throws XFormsException {
        XFormsElementFactory elementFactory = model.getContainer().getElementFactory();
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Element elementImpl;
            Node node = childNodes.item(index);
            if (node.getNodeType() != 1 || !XFormsElementFactory.isSubmissionElement(elementImpl = (Element)node)) continue;
            Submission submissionElement = (Submission)elementFactory.createXFormsElement(elementImpl, model);
            submissionElement.init();
        }
    }

    public static void initializeUIElements(Element element) throws XFormsException {
        Element elementImpl = element.getOwnerDocument().getDocumentElement();
        Container container = (Container)elementImpl.getUserData("");
        String evalAVT = elementImpl.getAttributeNS("http://betterform.sourceforge.net/xforms", "evalAVTs");
        if (evalAVT != null && evalAVT.length() != 0) {
            Initializer.initializeUIElements(container.getDefaultModel(), element, null, evalAVT);
        } else {
            Initializer.initializeUIElements(container.getDefaultModel(), element, null, null);
        }
    }

    public static void initializeUIElements(Model model, Element element, String repeatItemId, String evalAVT) throws XFormsException {
        Container container = model.getContainer();
        XFormsElementFactory xformsFactory = container.getElementFactory();
        CustomElementFactory customFactory = container.getCustomElementFactory();
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            AbstractUIElement uiElement;
            Model contextModel;
            Node node = childNodes.item(index);
            if (node.getNodeType() != 1) continue;
            Element elementImpl = (Element)node;
            if (elementImpl.getParentNode().getUserData("") instanceof Header) {
                return;
            }
            if (XFormsElementFactory.isUIElement(elementImpl)) {
                contextModel = Initializer.getContextModel(model, elementImpl);
                uiElement = (AbstractUIElement)xformsFactory.createXFormsElement(elementImpl, contextModel);
                Initializer.initXFormsObject(model, repeatItemId, uiElement);
                continue;
            }
            if (XFormsElementFactory.isActionElement(elementImpl)) {
                if (!Initializer.hasXFormsParent(elementImpl)) continue;
                Initializer.initializeActionElement(model, repeatItemId, xformsFactory, elementImpl);
                continue;
            }
            if (customFactory.isCustomElement(elementImpl)) {
                contextModel = Initializer.getContextModel(model, elementImpl);
                Object customElement = customFactory.createCustomXFormsElement(elementImpl, contextModel);
                if (customElement != null && customElement instanceof AbstractUIElement) {
                    Initializer.initXFormsObject(model, repeatItemId, (AbstractUIElement)customElement);
                }
                if (customElement == null || !(customElement instanceof AbstractAction)) continue;
                Initializer.initXFormsObject(model, repeatItemId, (AbstractAction)customElement);
                continue;
            }
            if (evalAVT != null && Initializer.hasAVT(elementImpl, evalAVT)) {
                contextModel = Initializer.getContextModel(model, elementImpl);
                uiElement = new AVTElement(elementImpl, contextModel);
                elementImpl.setUserData("", uiElement, null);
                Initializer.initXFormsObject(model, repeatItemId, uiElement);
                continue;
            }
            Initializer.initializeUIElements(model, elementImpl, repeatItemId, evalAVT);
        }
    }

    private static void initXFormsObject(Model model, String repeatItemId, AbstractAction actionElement) throws XFormsException {
        if (repeatItemId != null) {
            actionElement.setRepeatItemId(repeatItemId);
        }
        Initializer.initXFormsObject(model, repeatItemId, (XFormsElement)actionElement);
    }

    private static void initXFormsObject(Model model, String repeatItemId, AbstractUIElement uiElement) throws XFormsException {
        if (repeatItemId != null) {
            uiElement.setRepeatItemId(repeatItemId);
        }
        Initializer.initXFormsObject(model, repeatItemId, (XFormsElement)uiElement);
    }

    private static void initXFormsObject(Model model, String repeatItemId, XFormsElement xfElement) throws XFormsException {
        if (repeatItemId != null) {
            xfElement.setGeneratedId(model.getContainer().generateId());
            xfElement.registerId();
        }
        xfElement.init();
    }

    private static boolean hasXFormsParent(Node node) {
        Node parent = node.getParentNode();
        if (parent == null || parent.getNodeType() == 9) {
            return true;
        }
        Object userdata = parent.getUserData("");
        return userdata == null || !(userdata instanceof XFormsElement);
    }

    private static boolean hasAVT(Element element, String allowedAttributes) {
        String[] attrs;
        for (String attribute : attrs = allowedAttributes.split(" ")) {
            if (!element.hasAttribute(attribute) || element.getAttribute(attribute).indexOf("{") == -1) continue;
            return true;
        }
        return false;
    }

    public static void updateUIElements(Element element, Model model) throws XFormsException {
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node node = childNodes.item(index);
            if (node.getNodeType() != 1) continue;
            Element elementImpl = (Element)node;
            Object userData = elementImpl.getUserData("");
            if (userData != null && userData instanceof AbstractUIElement) {
                if (((AbstractUIElement)userData).getModel().getId().equals(model.getId())) {
                    ((AbstractUIElement)userData).refresh();
                    continue;
                }
                Initializer.updateUIElements(elementImpl, model);
                continue;
            }
            Initializer.updateUIElements(elementImpl, model);
        }
    }

    public static void disposeUIElements(Element element) throws XFormsException {
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node node = childNodes.item(index);
            if (node.getNodeType() != 1) continue;
            Element elementImpl = (Element)node;
            Object userData = elementImpl.getUserData("");
            if (userData != null && userData instanceof AbstractUIElement) {
                ((AbstractUIElement)userData).dispose();
                continue;
            }
            Initializer.disposeUIElements(elementImpl);
        }
    }

    public static Model getContextModel(Model model, Element element) throws XFormsBindingException {
        String bindId = null;
        if (element.hasAttributeNS("http://www.w3.org/2002/xforms", "bind")) {
            bindId = element.getAttributeNS("http://www.w3.org/2002/xforms", "bind");
        } else if (element.hasAttributeNS(null, "bind")) {
            bindId = element.getAttributeNS(null, "bind");
        } else if (element.hasAttributeNS("http://www.w3.org/2002/xforms", "repeat-bind")) {
            bindId = element.getAttributeNS("http://www.w3.org/2002/xforms", "repeat-bind");
        }
        if (bindId != null) {
            XFormsElement xFormsElement = model.getContainer().lookup(bindId);
            if (xFormsElement == null) {
                throw new XFormsBindingException("bind Element with id: '" + bindId + "' not found in model", (EventTarget)((Object)element), (Object)bindId);
            }
            if (!(xFormsElement instanceof Bind)) {
                throw new XFormsBindingException("element '" + bindId + "' is not a bind", (EventTarget)((Object)element), (Object)bindId);
            }
            return xFormsElement.getModel();
        }
        String modelId = null;
        if (element.hasAttributeNS("http://www.w3.org/2002/xforms", "model")) {
            modelId = element.getAttributeNS("http://www.w3.org/2002/xforms", "model");
        } else if (element.hasAttributeNS(null, "model")) {
            modelId = element.getAttributeNS(null, "model");
        }
        if (modelId != null) {
            XFormsElement xFormsElement = model.getContainer().lookup(modelId);
            if (xFormsElement == null) {
                throw new XFormsBindingException("model '" + modelId + "' not found", (EventTarget)((Object)element), (Object)modelId);
            }
            if (!(xFormsElement instanceof Model)) {
                throw new XFormsBindingException("element '" + modelId + "' is not a model", (EventTarget)((Object)element), (Object)modelId);
            }
            return (Model)xFormsElement;
        }
        return model;
    }
}

